<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;

class CategoriesController extends Controller
{
    /**
     * @var bool
     */
    private bool $api_call;
    /**
     * @brief assign true|false to $api_call by checking if the request is an API call
     *
     * @return void
     */
    public function __construct() {
        $this->api_call = request()->header('Accept') == "application/json";
    }

    public function index() {
        if (!$this->api_call) {
            return auth()->user()->role == 10 ?
                view('v1/02_dash-template/admin-pages/categories', ['categories'=>Category::get()]) :
                abort(401);
        } else {
            return successfulResponse([
                'categories' => Category::get()
            ]);
        }
    }
    public function actionHandler() {
        request()->validate([
            'cid'=>'numeric',
            'action'=>'required',
            'ctitle'=>'required|between:3,100',
            'icon'=>'required|string'
        ],
        [
            'action.required'=>'درخواست نامعتبر',
            'ctitle.unique'=>'دسته‌بندی `'.request('ctitle').'` تکراری می‌باشد',
            'ctitle.between'=>'طول نام دسته‌بندی باید بین 3 تا ۱۰۰ کاراکتر باشد',
        ]);
//        dd(request());
        if (request('action') == 'add') {
            if (request()->has('ctitle')) {
                $cat = new Category;
                $cat->title = request('ctitle');
                $cat->icon = request('icon');
                $cat->slug = str_replace(' ', '-', request('ctitle'));
                $cat->save();
                return back()->with('msg', 'دسته‌بندی جدید با موفقیت ایجاد شد');
            } else
                abort(400);
        } elseif (request('action') == 'delete') {
            if (request()->has('cid')) {
                Category::where('id', '=', request('cid'))->delete();
                return back()->with('msg', 'دسته‌بندی حذف شد');
            } else
                abort(400);
        } elseif (request('action') == 'edit') {
            if (request()->has('cid')) {
                Category::where('id', '=', request('cid'))->update(['title' => request('ctitle'), 'slug' => str_replace(' ', '-', request('ctitle')), 'icon' => request('icon')]);
                return back()->with('msg', 'دسته‌بندی ویرایش شد');
            } else
                abort(400);
        } else
            abort(400);
    }
}
