<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Models\OTP;
use App\Models\User;
use App\Http\Requests\LoginRequest;
use App\Http\Requests\RegisterRequest;

class LoginController extends Controller
{
    private function sendOTP($mobile, $otpval) {
//        $this->middleware('adminOnly');
    }
    private function createOTP($mobile) {
        $otpval = generateRandomString(6, 'numeric');
        $otp = new OTP();
        $otp->otp = $otpval;
        $otp->mobile = $mobile;
        $otp->expire_at = date('Y-m-d H:i:s', time()+180);
        $otp->save();
        return $otp;
    }
    private function validateOTP($mobile, $otpval) {
        $current_datetime = date('Y-m-d H:i:s', time());
        return OTP::where('otp', $otpval)->where('mobile', $mobile)->where('expire_at','>',$current_datetime)->exists();
    }

    public function viewLogin() {
        return view('v1/01_public/login');
    }

    /**
     * @return Route::dasboard.view or
     * @throws ValidationException
     */
    public function login(LoginRequest $request) {
        /**
         * user can either use `mobile` or `email` as `username`
         */
        $username_index = filter_var(request('username'), FILTER_VALIDATE_EMAIL) ? 'email' : 'mobile';
        $attributes = [
            $username_index => request('username'),
            'password' => request('password')
        ];
//        dd($attributes);
        /**
         * attempt to authenticate and log in the user based on provided credentials
         */
        if (auth()->attempt($attributes)) {
            session()->regenerate();
            auth()->user();
            return redirect()->route('dashboard.view');
        }
        /**
         *
         */
        throw ValidationException::withMessages(['err'=>'نام کاربری یا رمز عبور صحیح نیست']);
    }

    /**
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function viewRegister() {
        return view('v1/01_public/register-user');
    }

    /**
     * @param RegisterRequest $request
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Http\JsonResponse|\Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|void
     */
    public function register(RegisterRequest $request) {
        if (request('type') == 'otprequest') {
            $result = $this->createOTP(request('mobile'));
            return response()->json($result, 200);
        } elseif (request('type') == 'register') {
            if ($this->validateOTP(request('mobile'), request('otpval'))) {
                $aff_code  = generateRandomString(10, 'string');
                $check_aff = User::where('aff_code', $aff_code)->count();
                while ($check_aff > 0) {
                    $aff_code  = generateRandomString(10, 'string');
                    $check_aff = User::where('aff_code', $aff_code)->count();
                }
                $user = new User;
                $user->firstname = request('firstname');
                $user->lastname  = request('lastname');
                $user->mobile    = request('mobile');
                $user->idnum     = request('idnum');
                $user->email     = request('email');
                $user->password  = request('password');
                $user->aff_code  = $aff_code;
                $user->save();
                /**
                 * set proper sessions to redirect to /dashboard
                 */
                session()->regenerate();
                auth()->login($user);
                return redirect('/panel/dashboard');
            } else
                return redirect()->route('register.view')->with( 'error', 'کد اعتبارسنجی نامعتبر' );
        } else
            abort(400);
    }

    public function forgetPassword() {

    }

    public function logout() {
        auth()->logout();
        return redirect()->route('home');
    }
}
