<?php

namespace App\Http\Controllers;

use App\Http\Requests\MachineActuateRequest;
use App\Http\Requests\MachineRequest;
use App\Models\Order;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class MachineController extends Controller
{
    /**
     * @param $sid
     *
     * @return mixed
     */
    public function getOrderMachineId ($sid) {
        $service = Service::find($sid);
        return strlen($service->mid) > 2 ? $service->mid : false;
    }

    /**
     * @param MachineRequest $request
     *
     * @return string|void
     * @throws \Illuminate\Http\Client\ConnectionException
     */
    public function getMachineStatus(MachineRequest $request) {
//        $response = Http::get(env('VIRTUALIZATION_SERVICE_ADDR')."/api/v1/machines/".$request->oid."/status");
        $response = Http::withUrlParameters([
            'mid' => $request->vmid,
        ])->get(env('VIRTUALIZATION_SERVICE_ADDR').'/api/v1/machines/{mid}/status');

        if ($response->ok())
            return $response->body();
        else
            throwInternalServerError();
    }

    /**
     * @param MachineRequest $request
     *
     * @return \GuzzleHttp\Promise\PromiseInterface|\Illuminate\Http\Client\Response
     * @throws \Illuminate\Http\Client\ConnectionException
     */
    public function machineCmdHandler(MachineRequest $request) {
        return Http::withUrlParameters([
            'machineId' => $request->vmid,
        ])->post(env('VIRTUALIZATION_SERVICE_ADDR').'/api/v1/machines/{machineId}/start');
    }

    /**
     * @param $oid
     *
     * @return \Illuminate\Http\Client\Response
     */
    public static function createMachine ($oid) {
//        $instance = new self();
        $order = Order::find($oid);
        return Http::post( env('VIRTUALIZATION_SERVICE_ADDR') . '/machines', [
            'userId'      => auth()->user()->id,
            'orderId'     => $oid,
            'vmStr'       => $order->sid,
            'machineName' => auth()->user()->idnum.'-'.generateRandomString(5, 'string'),
        ]);
    }
}
