<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Coupon;
use App\Models\Payment;
use App\Models\User;
use Illuminate\Http\Request;
use Evryn\LaravelToman\Facades\Toman;
use Evryn\LaravelToman\CallbackRequest;
use App\Http\Controllers\ServicesController;
class PaymentController extends Controller
{
//    public function index(): string {
//        return "there are some bug's that I'm working on,will be done very soon";
//    }
    private function createPayment($oid, $tid, $amount, $status, $type = null) {
        $invoice         = new Payment;
        $invoice->oid    = $oid;
        $invoice->tid    = $tid;
        $invoice->amount = $amount;
        $invoice->status = $status;
        $type !== null ? $invoice->type = $type : null;
        $invoice->save();
//        return $invoice->id;
    }

    /**
     * @param $status
     * @param $tid
     * @param $oid
     *
     * @return bool
     */
    public static function updatePaymentStatus ($status, $tid = null, $oid = null) {
        $invoices = $tid === null ? Payment::where('oid', $oid)->get() : Payment::where('tid', $tid)->get();
        if (count($invoices) > 0) {
            if ($status == 'successful') {
                // update user credit if necessary
                $user = User::find(auth()->user()->id);
                foreach ($invoices as $invoice)
                    if ($invoice->type == 'credit') {
                        $user->credit = max(0, $user->credit - $invoice->amount);
                        $user->save();
                        break;
                    }
            }
            // update invoice[s] status
            $invoices->status = $status;
            $invoices->save();
        }
    }

    /**
     * @param $oid
     * @param $amount
     *
     * @return \Illuminate\Http\RedirectResponse|mixed|void
     */
    private function sendToIPG ($oid, $amount) {
        $user     = auth()->user();
        $order    = Order::find(request('oid'));
        // submit payment request to ipg
        $request  = Toman::amount($amount)
                         ->description("oid: ".$oid)
                         ->callback(route('callback.view'))
                         ->mobile($user->mobile)
                         ->email($user->email)
                         ->request();

        if ($request->successful()) {
            // reserve the slot for the user
            $order->status = "reserved";
            $order->save();
            // get the transaction ID and store it in payments table
            $transactionId = $request->transactionId();
            $this->createPayment($oid, $transactionId, $amount, 'pending');
            // Redirect to payment URL
            return $request->pay();
        }

        if ($request->failed()) {
            // Handle transaction request failure
            $order->status = 'cancelled';
            self::updatePaymentStatus('failed',null, $oid);
            return redirect()->route('callback.view', ['error'=>'خطا درگاه پرداخت، لطفا جهت پیگیری فرآیند پرداخت با پشتیبانی در ارتباط باشید']);
        }
    }
    public function createInvoice($oid, $amount, $type) {
        if ($type == 'coupon')
            $this->createPayment($oid, $type, $amount, 'pending', $type);
        else if ($type == 'credit') {
            $this->createPayment($oid, $type, $amount, 'pending', $type);
        }
        else
            $this->sendToIPG($oid, $amount);
    }
    public function processPayment (CallbackRequest $request) {
        $user     = auth()->user();
        $result = [
            'status' => '',
            'message'=> ''
        ];
        $tid     = $request->transactionId();
        $invoice = Payment::where('tid', $tid);
        if ($invoice !== null) {
            // verify the payment
            $payment = $request->amount($invoice->amount)->verify();
            if ($payment->successful()) {
                // Store the successful transaction details
                $referenceId     = $payment->referenceId();
                $invoice->rid    = $referenceId;
                $invoice->status = 'successful';
                $invoice->save();
                // TODO: handle referer credit, if applicable
                // preparing the proper response
                $result->status  = 200;
                $result->message = 'پرداخت با موفقیت انجام شد، شماره رفرنس: '.convertNumbers($referenceId);
            }

            if ($payment->alreadyVerified()) {
                // preparing the proper response
                $result->status  = 208;
                $result->message = 'این پرداخت پیش از این تایید گردیده است، شماره رفرنس: '.convertNumbers($payment->rid);
            }

            if ($payment->failed()) {
                // preparing the proper response
                $result->status  = 500;
                $result->message = 'خطا در پرداخت، شماره تراکنش: '.convertNumbers($tid);
            }

            // process order based on payment status
            OrdersController::processOrder($invoice->oid, $result->status);

            return view('v1/02_dash-template/customer-pages/callback', ['result'=>$result]);
        }
    }
}
