<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Validation\Rules\Password;

class RegisterController extends Controller
{
    private function sendOTP() {
        request()->validate([
            'mobile'=>'required|unique:users,mobile|numeric|digits:11',
            'idnum'=>'required|unique:users,idnum|numeric|digits:10'
        ],[
            'mobile.required' => 'فیلد تلفن همراه الزامی می‌باشد',
            'mobile.unique' => 'تلفن همراه وارد شده قبلا در سیستم ثبت شده است',
            'mobile.numeric' => 'تلفن همراه وارد شده نامعتبر می‌باشد',
            'mobile.digits' => 'تلفن همراه باید ۱۱ کاراکتر باشد',
            'idnum.required' => 'فیلد کد ملی الزامی می‌باشد',
            'idnum.unique' => 'کد ملی وارد شده قبلا در سیستم ثبت شده است',
            'idnum.numeric' => 'کد ملی وارد شده نامعتبر می‌باشد',
            'idnum.digits' => 'کد ملی باید ۱۰ کاراکتر باشد'
        ]);
        $otp_value = generateRandomString(6, 'numeric');


        /**
         * send otp to user mobile phone
         */
        //$result = sendOTPMessage(request('mobile'), $otp_value, "register");
        $result = true;
        if ($result) {
            $otp_lifetime = getCurrentTimestamp()+305;
            session()->put('userinfo', [
                'idnum'=>request('idnum'),
                'mobile'=>request('mobile'),
                'otp_value'=>$otp_value,
                'otp_lifetime'=>$otp_lifetime,
                'otp_status'=>0]);
        }
        return $result;
    }
    private function getOTP()
    {
        $session = session()->get('userinfo');
        request()->validate([
            'otp' => ['required', 'numeric', 'digits:6', "regex:({$session['otp_value']})"]
        ], [
            'otp.required' => 'فیلد اعتبارسنجی الزامی می‌باشد',
            'otp.digits' => 'کد اعتبارسنجی باید ۶ کاراکتر باشد',
            'otp.numeric' => 'فرمت کد اعتبارسنجی نا معتبر',
            'otp.regex' => 'کد اعتبارسنجی نامعتبر، لطفا مجددا تلاش کنید'
        ]);
        session()->put('userinfo.otp_status', 1);
    }
    private function addUser() {
        request()->validate([
            'firstname'=>'required',
            'lastname'=>'required',
            'mobile'=>'required|unique:users,mobile|numeric|digits:11',
            'idnum'=>'required|unique:users,idnum|numeric|digits:10',
            'email'=>'required|unique:users,email|email|between:5,100',
            'password' => [
                'required',
                'between:8,100',
                'regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)[a-zA-Z\d]{8,}$/',
                'confirmed'
            ],
            'password_confirmation'=>'required'
        ],[
            'firstname.required' => 'فیلد نام الزامی می‌باشد',
            'lastname.required' => 'فیلد نام خانوادگی الزامی می‌باشد',
            'mobile.required' => 'فیلد تلفن همراه الزامی می‌باشد',
            'mobile.unique' => 'تلفن همراه وارد شده قبلا در سیستم ثبت شده است',
            'mobile.numeric' => 'تلفن همراه وارد شده نامعتبر می‌باشد',
            'mobile.digits' => 'تلفن همراه باید ۱۱ کاراکتر باشد',
            'idnum.required' => 'فیلد کد ملی الزامی می‌باشد',
            'idnum.unique' => 'کد ملی وارد شده قبلا در سیستم ثبت شده است',
            'idnum.numeric' => 'کد ملی وارد شده نامعتبر می‌باشد',
            'idnum.digits' => 'کد ملی باید ۱۰ کاراکتر باشد',
            'email.required' => 'فیلد پست الکترونیک الزامی می‌باشد',
            'email.unique' => 'ایمیل وارد شده قبلا در سیستم ثبت شده است',
            'email.email' => 'فرمت ایمیل نامعتبر',
            'email.between' => 'ایمیل باید بین ۵ تا ۱۰۰ کاراکتر باشد',
            'password.required' => 'فیلد رمز عبور الزامی می‌باشد',
            'password.regex' => 'طول رمز عبور باید حداقل ۸ کاراکتر و شامل اعداد، حروف کوچک و بزرگ باشد',
            'password.between' => 'طول رمز عبور باید بین ۸ تا ۱۰۰ کاراکتر باشد',
            'password.confirmed' => 'فیلد‌های رمز عبور و تکرار رمز عبور، یکسان نیستند',
            'password_confirmation.required' => 'فیلد تکرار رمز عبور الزامی می‌باشد'
        ]);
        $attributes = request()->all();
        unset($attributes['password_confirmation']);
        $attributes['type'] = 3;
        $aff_code  = generateRandomString(8, 'string');
        $check_aff = User::where('aff_code', $aff_code)->count();
        while ($check_aff > 0) {
            $aff_code  = generateRandomString(8, 'string');
            $check_aff = User::where('aff_code', $aff_code)->count();
        }

        $user = new User;
        $user->firstname = request('firstname');
        $user->lastname  = request('lastname');
        $user->mobile    = request('mobile');
        $user->idnum     = request('idnum');
        $user->email     = request('email');
        $user->password  = request('password');
        $user->aff_code  = $aff_code;
        $user->save();

        /**
         * set proper sessions to redirect to /dashboard
         */
        session()->regenerate();
        auth()->login($user);
        return redirect()->route('dashboard.view');
   }
    public function requestHandler() {
        if (request()->getMethod() === 'POST') {
            if (session()->has('userinfo')) {
                $session = session()->get('userinfo');
                if ($session['otp_status'] === 1) {
                    if (request()->has('firstname')) {
                        $this->addUser();
                        session()->forget('userinfo');
                        return redirect('/panel/dashboard');
                    }
                    return view('v1/01_public/register-user');
                }
                elseif ($session['otp_lifetime'] > getCurrentTimestamp()) {
                    if (request()->has('otp')) {
                        $this->getOTP();
                        return view('v1/01_public/register-user');
                    }
                    else
                        return view('v1/01_public/register-get-otp');
                }
                else
                    return view('v1/01_public/register-send-otp');
            } else {
                if ($this->sendOTP())
                    return view('v1/01_public/register-get-otp');
                else
                    return view('v1/01_public/register-get-otp')->with('error', 'خطا در ارسال پیامک، لطفا مجددا تلاش کنید.');
            }
        } else {
            //session()->forget('userinfo');
            if (session()->has('userinfo')) {
                $session = session()->get('userinfo');
                if ($session['otp_status'] === 1)
                    return view('v1/01_public/register-user');
                elseif ($session['otp_lifetime'] > getCurrentTimestamp())
                    return view('v1/01_public/register-get-otp');
                else {
                    session()->forget('userinfo');
                    return view('v1/01_public/register-send-otp');
                }
            } else
                return view('v1/01_public/register-send-otp');
        }
    }
}
