<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\TemplateItem;
use App\Http\Requests\TemplateValueRequst;
use App\Http\Requests\SubmitTemplateValueRequst;


class TemplateController extends Controller
{
    /**
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function viewTemplateSettings() {
//        return TemplateItem::all();
        return view('v1.02_dash-template.admin-pages.template-items', ['items'=>TemplateItem::all()]);
    }

    /**
     * @param SubmitTemplateValueRequst $request
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function submitTemplateSettings(SubmitTemplateValueRequst $request) {
//        $tempalteItem = TemplateItem::find($request->id);
//        $tempalteItem->item_value = $request->value;
//        $tempalteItem->save();
        TemplateItem::where('item_key', '=', $request->key)->update(['item_value' => $request->value]);
        return back()->with('msg', "تنظیمات قالب با موفقیت ثبت شد");
//        session()->flash('message', "تنظیمات قالب با موفقیت ثبت شد");
//        return redirect()->route('template-settings.view');
    }

    /**
     * @param TemplateValueRequst $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function fetchValue(TemplateValueRequst $request) {
        $value = TemplateItem::where('item_key', request('key'))->first();
        return response()->json($value);
    }
}
