<?php

namespace App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\ValidationException;

class LoginRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'username' => 'required',
            'password' => ['required', Password::min(8)]
        ];
    }
    /**
     * @param Validator $validator
     *
     * @return [redirect with message]
     */
    public function failedValidation(Validator $validator)
    {
        $headers = apache_request_headers();
        $headers['Accept'] != "application/json" ?
            throw ValidationException::withMessages(['err'=>'نام کاربری یا رمز عبور صحیح نیست']) :
            throwBadRequestError(['errors' => ['نام کاربری/رمز عبور نامعتبر']]);
    }
}
