<?php


namespace App\Http\Requests;
use \Illuminate\Foundation\Http\FormRequest;

class SubmitOrderRequest extends FormRequest {
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'sid'=>'required|numeric|exists:services,id',
            'type'=>'required|string',
            'from'=>'required_if:type,==,daily|shamsi_date',
            'until'=>'required_if:type,==,daily|shamsi_date',
            'date'=>'required_if:type,==,hourly|shamsi_date',
            'times'=>'required_if:type,==,hourly|array',
            'times.*'=>'numeric',
            'pph'=>'required_if:type,==,hourly|numeric',
            'ppd'=>'required_if:type,==,daily|numeric',
        ];
    }
}
