<?php

use IPPanel\Client;
use IPPanel\Errors\Error;
use IPPanel\Errors\HttpException;
use IPPanel\Errors\ResponseCodes;
use Illuminate\Http\Exceptions\HttpResponseException;

function isAdmin(): bool {
    return auth()->user()->role == 10;
}

function getCurrentTimestamp() {
    return strtotime(date('Y-m-d H:i:s'));
}
function generateRandomString($len, $type) {
    switch ($type) {
        case 'string':
            $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            break;
        case 'numeric':
            $characters = '0123456789';
            break;
        default:
            return false;
    }
    $output = '';
    for ($i = 0; $i < $len; $i++) {
        $index = rand(0, strlen($characters) - 1);
        $output .= $characters[$index];
    }
    return $output;
}

function convertNumbers($str, $type = "EnToFa") {
    if ($type === "FaToEn")
        return str_replace(['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'],['0','1','2','3','4','5','6','7','8','9'],$str);
    else
        return str_replace(['0','1','2','3','4','5','6','7','8','9'],['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'],$str);
}

function gregorianToJalali($datetime, $format = "Y/m/d", $lang = "fa") {
    require_once "jdf.php";
    return jdate($format, strtotime($datetime), '', 'Asia/Tehran', $lang);
}
function jalaliToGregorian($datetime) {
    require_once "jdf.php";
    $inputDate = explode('/', $datetime);
    $date = jalali_to_gregorian($inputDate[0], $inputDate[1], $inputDate[2], '-');
    return $date;
}

function sendOTPMessage($receptor, $token, $template) {
    $apiKey = 'JnTHDWMzolACCuoGMUnli8Ju86NvSz9NXNU1Lj92hbg=';
    $client = new Client($apiKey);

    try{
        $patternValues = [
            "verification-code" => $token,
        ];
        $bulkID = $client->sendPattern(
            "ku73b8zn2e8ah4k",
            "3000505",
            $receptor,
            $patternValues,
        );
        return true;
    } catch (Error $e) {
//        var_dump($e->unwrap());
//        echo $e->getCode();
//
//        if ($e->code() == ResponseCodes::ErrUnprocessableEntity) {
//            die("Unprocessable entity");
//        }
//        exit();
        return false;
    } catch (HttpException $e) {
//        var_dump($e->getMessage());
//        die($e->getCode());
        return false;
    }
}

/**
 * @param integer $status
 * @param string $message
 * @param null/array $data
 *
 * @return [response] <json>
 */
function fetchResponse($status, $message, $data = NULL) {
    $result = ['status'=> $status, 'message' => $message];
    $data != NULL ? $result = array_merge($result, ['data' => $data]) : NULL;
    return response()->json($result, $status,['Charset' => 'utf-8'],
        JSON_UNESCAPED_UNICODE);
}

/**
 * @param null $data <optional>
 *
 * @return string <json>
 */
function successfulResponse ($data = NULL) {
    return fetchResponse(200, 'OK', $data);
}

/**
 * @param null $data <optional>
 *
 * @return string <json>
 */
function createdResponse ($data = NULL) {
    return fetchResponse(201, 'Created', $data);
}

/**
 * @param null $data <optional>
 *
 * @return string <json>
 */
function throwBadRequestError ($data = NULL) {
    throw new HttpResponseException(fetchResponse(400, 'Bad Request', $data));
}

/**
 * @param null $data <optional>
 *
 * @return string <json>
 */
function throwUnauthorizedError ($data = NULL) {
    throw new HttpResponseException(fetchResponse(401, 'Unauthorized', $data));
}

/**
 * @param null $data <optional>
 *
 * @return string <json>
 */
function throwForbiddenError ($data = NULL) {
    throw new HttpResponseException(fetchResponse(403, 'Forbidden', $data));
}

/**
 * @param null $data <optional>
 *
 * @return string <json>
 */
function throwNotFoundError ($data = NULL) {
    throw new HttpResponseException(fetchResponse(404, 'Not Found', $data));
}

/**
 * @param null $data <optional>
 *
 * @return string <json>
 */
function throwInternalServerError ($data = NULL) {
    throw new HttpResponseException(fetchResponse(500, 'Internal Server Error', $data));
}
