<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->unsignedBigInteger('sid'); // Service ID
            $table->string('hours')->nullable();
            $table->dateTime('date')->nullable();
            $table->dateTime('from')->nullable();
            $table->dateTime('until')->nullable();
            $table->string('status'); // done - cancelled - reserved
            $table->dateTime('placement_datetime');
            $table->dateTime('callback_datetime')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
};
