<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('category_id');
            $table->string('title');
            $table->text('excerpt');
            $table->text('description');
            $table->string('parent')->nullable();
            $table->string('children')->nullable();
            $table->boolean('stared')->default(0);
            $table->integer('hourly_rate')->nullable();
            $table->integer('daily_rate')->nullable();
            $table->integer('quantity_per_day')->default(0);

            $table->foreign('category_id')->references('id')->on('categories');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('services');
    }
};
