@extends("v1/02_dash-template/layouts/layout-admin")

@section('tab-title')| سفارشات @endsection

@section("page-title") سفارشات @endsection

@section('page-styles')
<link rel="stylesheet" type="text/css" href="{{ asset("statics/dash-template/vendor_components/datatable/datatables.min.css") }}"/>
<style>
    table {
        cursor: default !important;
    }
</style>
@endsection

@section("page-body")
<div class="box">
    <div class="box-body">
        <div class="table-responsive">
            <table class="table table-sm table-bordered text-center">
                <thead>
                    <tr class="bg-pale-dark">
                        <th class="font-weight-bold">#</th>
                        <th class="font-weight-bold">کد ملی</th>
                        <th class="font-weight-bold">نام کامل</th>
                        <th class="font-weight-bold">سرویس</th>
                        <th class="font-weight-bold">نوع</th>
                        <th class="font-weight-bold">حجم</th>
                        <th class="font-weight-bold">تاریخ ثبت</th>
                        <th class="font-weight-bold">تاریخ پرداخت</th>
                        <th class="font-weight-bold">وضعیت</th>
                        <th class="font-weight-bold">تغییر وضعیت</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($orders as $order)
                    <tr class="@if($order->status == "reserved") bg-pale-warning @elseif($order->status == "done") bg-pale-success @else bg-pale-danger @endif">
                        <td>{{ $order->id }}</td>
                        <td>{{ $order->idnum }}</td>
                        <td>{{ $order->firstname.' '.$order->lastname }}</td>
                        <td>{{ $order->title }}</td>
                        <td>{{ is_null($order->hours) ? "روزانه" : "ساعتی" }}</td>
                        <td class="ltr">{{ is_null($order->hours) ? gregorianToJalali($order->from).' الی '.gregorianToJalali($order->until) : gregorianToJalali($order->date).' -> '.$order->hours }}</td>
                        <td class="ltr">{{ gregorianToJalali($order->placement_datetime, "Y/m/d H:i") }}</td>
                        <td class="ltr">{{ is_null($order->callback_datetime) ? "-" : gregorianToJalali($order->callback_datetime, "Y/m/d H:i") }}</td>
                        <td class="ltr">{{ $order->status }}</td>
                        <form action="{{ route('change-order-status.submit') }}" method="post">@csrf <input type="hidden" name="oid" value="{{ $order->id }}">
                            <td>
                                @if($order->status == "reserved")
                                    <button class="btn btn-social-icon btn-circle btn-sm btn-success m-0" name="action" value="done" type="submit"><i class="mdi mdi-check-circle-outline"></i></button> <button class="btn btn-social-icon btn-circle btn-sm btn-danger m-0" name="action" value="cancelled" type="submit"><i class="mdi mdi-cancel"></i></button>
                                @elseif($order->status == "done")
                                    <button class="btn btn-social-icon btn-circle btn-sm btn-danger m-0" name="action" value="cancelled" type="submit"><i class="mdi mdi-cancel"></i></button>
                                @else
                                    <button class="btn btn-social-icon btn-circle btn-sm btn-success m-0" name="action" value="done" type="submit"><i class="mdi mdi-check-circle-outline"></i></button>
                                @endif
                            </td>
                        </form>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('page-scripts')
    <script src="{{ asset("statics/dash-template/vendor_components/datatable/datatables.min.js") }}"></script>
    <script>
        var table = $('table').DataTable();
    </script>
@endsection
