@extends("v1/02_dash-template/layouts/layout-admin")

@section('tab-title', ' | مدیریت سرویس ها')

@section("page-title" , 'مدیریت سرویس ها')

@section("page-styles")
<link rel="stylesheet" href="{{ asset("statics/dash-template/vendor_components/select2/dist/css/select2.css") }}">
@endsection

@section("page-body")
    <!-- /.modal -->
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">ثبت سرویس جدید</h3>
            <ul class="box-controls pull-right">
                <li><a class="box-btn-slide" href="#"></a></li>
            </ul>
        </div>
        <div class="box-body">
            <form action="{{ route('service.action') }}" method="POST">
                @csrf
                <div class="row rtl">
                    <div class="col-4">
                        <div class="form-group">
                            <h5><span class="text-danger">*</span> عنوان سرویس:</h5>
                            <div class="controls">
                                <input name="title" value="{{ old('title') }}" type="text" class="form-control" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <h5><span class="text-danger">*</span> دسته‌بندی:</h5>
                            <select class="form-control select2 select2-hidden-accessible" name="category_id" style="width: 100%;" tabindex="-1" aria-hidden="true" required>
                                <option value="0">انتخاب کنید</option>
                            @foreach($categories as $category)
                                <option value="{{ $category['id'] }}">{{ $category['title'] }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <h5><span class="text-danger"></span> پدر:</h5>
                            <select class="form-control select2" name="parent_id" style="width: 100%;">
                                <option value="0" selected>ندارد</option>
                                @foreach($services as $service)
                                <option value="{{ $service['sid'] }}">{{ $service['s_title'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <h5><span class="text-danger"></span> فرزندان:</h5>
                            <select class="form-control select2 select2-hidden-accessible rtl" name="children_ids[]" multiple="" data-placeholder="فرزندان این سرویس را انتخاب کنید" style="width: 100%; height: 80px !important" tabindex="-1" aria-hidden="true">
                                <option value="0">ندارد</option>
                                @foreach($services as $service)
                                <option value="{{ $service['sid'] }}">{{ $service['s_title'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <h5><span class="text-danger">*</span> تعرفه ساعتی:</h5>
                            <div class="controls">
                                <input name="hourly_rate" value="{{ old('hourly_rate') }}" type="text" class="form-control ltr" placeholder="ریال" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <h5><span class="text-danger">*</span> تعرفه روزانه:</h5>
                            <div class="controls">
                                <input name="daily_rate" value="{{ old('daily_rate') }}" type="text" class="form-control ltr" placeholder="ریال" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <h5><span class="text-danger">*</span> تعداد قابل ارائه:</h5>
                            <div class="controls">
                                <input name="quantity" value="{{ old('quantity') }}" type="text" class="form-control ltr" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="form-group">
                            <h5>کد ماشین:</h5>
                            <div class="controls">
                                <input name="mid" value="{{ old('mid') }}" type="text" class="form-control ltr" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="form-group" style="padding-top: 35px; margin-bottom: 0">
                            <input type="checkbox" name="stared" value="1" id="md_checkbox_3" class="chk-col-purple" />
                            <label for="md_checkbox_3">نمایش سرویس در خانه</label>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <h5><span class="text-danger">*</span> خلاصه سرویس:</h5>
                            <textarea id="excerpt" name="excerpt" class="form-control">{{ old('excerpt') }}</textarea>
                        </div>
                    </div>
                    <div class="col-8">
                        <div class="form-group">
                            <h5><span class="text-danger">*</span> شرح سرویس:</h5>
                            <textarea id="details" name="details" class="form-control">{{ old('details') }}</textarea>
                        </div>
                    </div>
                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-success btn-rounded font-weight-bold w-25">ثبت سرویس</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    @if(count($services) > 0)
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">مدیریت سرویس ها</h3>
            <ul class="box-controls pull-right">
                <li><a class="box-btn-slide" href="#"></a></li>
            </ul>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr class="bg-pale-gray">
                            <th class="font-weight-bold text-center">عنوان</th>
                            <th class="font-weight-bold text-center">دسته‌بندی</th>
                            <th class="font-weight-bold text-center">پدر</th>
                            <th class="font-weight-bold text-center">فرزندان</th>
                            <th class="font-weight-bold text-center">تعرفه ساعتی</th>
                            <th class="font-weight-bold text-center">تعرفه روزانه</th>
                            <th class="font-weight-bold text-center">ظرفیت ارائه</th>
                            <th class="font-weight-bold text-center">نمایش در خانه</th>
                            <th class="font-weight-bold text-center">کد ماشین</th>
                            <th class="font-weight-bold text-center">ویرایش</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($services as $service)
                    @php
                        $parent = strlen($service["parent"]) > 5 ? json_decode($service["parent"], true) : [['id'=>'0', 'title'=>'-']];
                        $children = strlen($service["children"]) > 5 ? json_decode($service["children"], true) : [['id'=>'0', 'title'=>'-']];
                    @endphp
                    <tr>
                        <td>{{ $service["s_title"] }}</td>
                        <td>{{ $service["c_title"] }}</td>
                        <td>{{ $parent[0]['title'] }}</td>
                        <td>@foreach($children as $child) {!! '<span class="badge badge-sm badge-default">'.$child['title'].'</span>' !!} @endforeach</td>
                        <td>{{ number_format($service["hourly_rate"], 0, "", ",") }}</td>
                        <td>{{ number_format($service["daily_rate"], 0, "", ",") }}</td>
                        <td>{{ $service["qpd"] }}</td>
                        <td>{{ $service["stared"] == 1 ? 'بلی' : 'خیر' }}</td>
                        <td>{{ $service['mid'] }}</td>
                        <td class="text-center">
                            <button type="button" onclick="fetchDataForEditForm({{ $service["sid"] }})" class="btn btn-outline-warning btn-xs" data-toggle="modal" data-target="#modal-default">
                                ویرایش
                            </button>
                        </td>
                    </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif
@endsection

@section('page-starter')
    <!-- modal Area -->
    <div class="modal fade" id="modal-default">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p id="preloader" class="text-center text-primary">لطفا تامل فرمائید...</p>
                    <form id="edit-form" action="{{ route('service.action') }}" method="POST">
                        @csrf
                        <input type="hidden" id="sid" name="id">
                        <div class="row rtl">
                            <div class="col-6">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> عنوان سرویس:</h5>
                                    <div class="controls">
                                        <input id="title" name="title" value="{{ old('title') }}" type="text" class="form-control" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> دسته‌بندی:</h5>
                                    <select id="category" class="form-control select2 select2-hidden-accessible" name="category_id" style="width: 100%;" tabindex="-1" aria-hidden="true" required>
                                        <option value="0">انتخاب کنید</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category['id'] }}">{{ $category['title'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <h5><span class="text-danger">* </span>کد ماشین:</h5>
                                    <div class="controls">
                                        <input id="mid" name="mid" value="{{ $service['mid'] }}" type="text" class="form-control ltr" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="form-group">
                                    <h5><span class="text-danger"></span> پدر:</h5>
                                    <select id="parent" class="form-control select2" name="parent_id" style="width: 100%;">
                                        <option value="0" selected>ندارد</option>
                                        @foreach($services as $service)
                                            <option value="{{ $service['sid'] }}">{{ $service['s_title'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-8">
                                <div class="form-group">
                                    <h5><span class="text-danger"></span> فرزندان:</h5>
                                    <select id="children" class="form-control select2 select2-hidden-accessible rtl" name="children_ids[]" multiple="" data-placeholder="فرزندان این سرویس را انتخاب کنید" style="width: 100%; height: 80px !important" tabindex="-1" aria-hidden="true">
                                        <option value="0">ندارد</option>
                                        @foreach($services as $service)
                                            <option value="{{ $service['sid'] }}">{{ $service['s_title'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> تعرفه ساعتی:</h5>
                                    <div class="controls">
                                        <input id="hourly-rate" name="hourly_rate" type="text" class="form-control ltr" placeholder="ریال" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> تعرفه روزانه:</h5>
                                    <div class="controls">
                                        <input id="daily-rate" name="daily_rate" type="text" class="form-control ltr" placeholder="ریال" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> تعداد قابل ارائه:</h5>
                                    <div class="controls">
                                        <input id="quantity" name="quantity" type="text" class="form-control ltr" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group" style="padding-top: 35px; margin-bottom: 0">
                                    <input id="stared" type="checkbox" name="stared" value="1" class="chk-col-purple" />
                                    <label for="stared">نمایش سرویس در خانه</label>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> خلاصه سرویس:</h5>
                                    <textarea id="excerpt-edit" name="excerpt" class="form-control"></textarea>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> شرح سرویس:</h5>
                                    <textarea id="details-edit" name="details" class="form-control"></textarea>
                                </div>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-success btn-rounded font-weight-bold w-25">ثبت تغییرات</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->
@endsection

@section("page-scripts")
    <script src="{{ asset("statics/dash-template/vendor_components/select2/dist/js/select2.full.js") }}"></script>
    <script src="{{ asset('statics/vendor/tinymce/tinymce.min.js') }}"></script>
    <script>
        $(document).ready(function () {
            tinymce.init({
                selector: 'textarea#excerpt',
                plugins: 'advlist link image lists emoticons directionality',
                toolbar: 'undo redo | styles | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | emoticons link | ltr rtl',
                directionality : "rtl",
                menubar: false,
            });
            tinymce.init({
                selector: 'textarea#details',
                plugins: 'advlist link image lists emoticons directionality',
                toolbar: 'undo redo | styles | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | emoticons link | ltr rtl',
                directionality : "rtl",
                menubar: false,
            });
            tinymce.init({
                selector: 'textarea#details-edit',
                plugins: 'advlist link image lists emoticons directionality',
                toolbar: 'undo redo | styles | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | emoticons link | ltr rtl',
                directionality : "rtl",
                menubar: false,
            });
            tinymce.init({
                selector: 'textarea#excerpt-edit',
                plugins: 'advlist link image lists emoticons directionality',
                toolbar: 'undo redo | styles | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | emoticons link | ltr rtl',
                directionality : "rtl",
                menubar: false,
                height : "200"
            });
            //Initialize Select2 Elements
            $('.select2').select2({
                dir: "rtl"
            });
            // var dailyRateElement = $('#daily-rate');
            // var hourlyRateElement = $('#hourly-rate');
            // hourlyRateElement.on('input', function () {
            //     hreVal = hourlyRateElement.val();
            //     hourlyRateElement.val(addCommas(hreVal.replace(/,/g, "")));
            // });
        });
        function fetchDataForEditForm(id) {
            let url = "{{ route('service.get') }}";
            let excerpt = tinymce.get('excerpt-edit');
            let details = tinymce.get('details-edit');
            $.ajax({
                cache: false, url: url, type: 'GET', datatype: 'jsonp',
                data: { "id" : id },
                beforeSend: function() {
                    $("#sid").val(id);
                    $('#preloader').show();
                    $('#edit-form').hide();
                },
                success: function (data) {
                    $("#mid").val(data.mid);
                    $("#title").val(data.s_title);
                    $("#hourly-rate").val(data.hourly_rate);
                    $("#daily-rate").val(data.daily_rate);
                    $("#quantity").val(data.qpd);
                    $("#category").val(data.cid).trigger("change");
                    if (data.parent != null) {
                        let parent = JSON.parse(data.parent)[0];
                        $("#parent").val(parent.id).trigger("change");
                    } else {
                        $("#parent").val(0).trigger("change");
                    }
                    if (data.children != null) {
                        let selectedChildren = [];
                        let children = JSON.parse(data.children);
                        for (let key in children)
                            selectedChildren.push(children[key].id);
                        $("#children").val(selectedChildren).trigger("change");
                    } else {
                        $("#children").val(0).trigger("change");
                    }
                    if (data.stared == 1)
                        $("#stared").attr("checked", "checked");
                    excerpt.setContent(data.excerpt);
                    details.setContent(data.description);
                    $('#preloader').hide();
                    $('#edit-form').show();
                },
                error: function(data, xhr,ajaxOptions,thrownError) {
                    if (ajaxOptions === 'Unauthorized') {
                        console.log("Unauthorized");
                    } else if (ajaxOptions === "Not Acceptable") {
                        console.log("Not Acceptable");
                    } else {
                        console.log(ajaxOptions);
                    }
                }
            });
        }
        // function addCommas(nStr)
        // {
        //     nStr += '';
        //     var x = nStr.split('.');
        //     var x1 = x[0];
        //     var x2 = x.length > 1 ? '.' + x[1] : '';
        //     var rgx = /(\d+)(\d{3})/;
        //     while (rgx.test(x1)) {
        //         x1 = x1.replace(rgx, '$1' + ',' + '$2');
        //     }
        //     return x1 + x2;
        // }
    </script>
@endsection

