@extends("v1/02_dash-template/layouts/layout-admin")

@section('tab-title', ' | تنظیمات قالب سایت')

@section("page-title" , 'تنظیمات قالب سایت')

@section("page-body")
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">ثبت / ویرایش محتوای قالب</h3>
        </div>
        <div class="box-body">
            <form action="{{ route('template-settings.submit') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="col-md-2 col-12">
                        <div class="form-group">
                            <select id="key" name="key" class="form-control ltr">
                                <option>Choose One...</option>
                                @foreach($items as $item)
                                <option value="{{ $item['item_key'] }}">{{ $item['item_key'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <button id="change-input" class="btn btn-block btn-warning" type="button">متن / لینک</button>
                        <button id="submit" class="btn btn-block btn-info mt-4" type="submit">ثبت / ویرایش</button>
                    </div>
                    <div class="col-md-10 col-12">
                        <div id="value-box" class="form-group">
                            <input id="value" type="text" name="value" class="form-control ltr">
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section("page-scripts")

<script src="{{ asset('statics/vendor/tinymce/tinymce.min.js') }}"></script>
<script>
var changeCount = 0;
var changeState = 'textarea';
function initTextarea() {
    tinymce.init({
        selector: 'textarea',
        plugins: 'advlist link image lists emoticons',
        toolbar: 'undo redo | styles | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | emoticons link'
    });
}
$('#change-input').click( function () {
    if (changeState === 'textarea') {
        changeCount++;
        changeState = 'input';
        $('#value-box').html('<textarea id="value" name="value" class="form-control"></textarea>');
        initTextarea();
    }
    else {
        changeCount++;
        changeState = 'textarea';
        $('#value-box').html('<input id="value" type="text" name="value" class="form-control ltr">');
    }
});
$('#key').change( function () {
    $.ajax({
        type:'POST',
        url: "{{ route('get-item-value.submit') }}",
        data: { key: $(this).val() },
        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
        beforeSend: function () {
            console.clear();
            $("#key, #submit").attr('disabled', true);
        },
        success: (response) => {
            try {
                changeCount === 0 || changeState === 'textarea' ? $('#value').val(response.item_value) : tinymce.activeEditor.setContent(response.item_value);
            } catch (e) {
                tinymce.activeEditor.setContent('');
            }
        },
        error: function(response){
            console.log(response.responseJSON.message);
        },
        complete: function () {
            $("#key, #submit").attr('disabled', false);
        }
    });
});
</script>
@if (session()->has('message'))
<script>
    $.toast({
        text: '{{ session()->get('message') }}',
        position: 'bottom-left',
        loaderBg: '#ff6849',
        icon: 'success',
        textAlign: 'center',
        hideAfter: 5000
    });
</script>
@endif

@endsection
