@extends("v1/02_dash-template/layouts/layout-admin")

@section('tab-title')| لیست کاربران @endsection

@section("page-title")لیست کاربران سایت @endsection

@section("page-styles")
<link rel="stylesheet" type="text/css" href="{{ asset("statics/dash-template/vendor_components/datatable/datatables.min.css") }}"/>
@endsection

@section("page-body")
<div class="box">
    <div class="box-body">
        <div class="table-responsive-sm">
            <table class="table table-hover table-bordered text-center">
                <thead>
                    <tr class="bg-pale-dark">
                        <th class="font-weight-bold col-1">کد ملی</th>
                        <th class="font-weight-bold col-1">نام</th>
                        <th class="font-weight-bold col-2">نام خانوادگی</th>
                        <th class="font-weight-bold col-2">شماره همراه</th>
                        <th class="font-weight-bold col-1">کد معرف</th>
                        <th class="font-weight-bold col-1">معرف</th>
                        <th class="font-weight-bold col-1">اعتبار</th>
                        <th class="font-weight-bold col-2">تاریخ عضویت</th>
                        <th class="font-weight-bold col-1">سطح</th>
                        <th class="font-weight-bold col-1">ذخیره</th>
                    </tr>
                </thead>
                <tbody class="text-sm">
                @foreach($users as $user)
                    <tr>
                        <form action="{{ route('edit-user-info.submit') }}" method="post">
                        @csrf
                        <input name="action" value="change_user_data" type="hidden">
                        <td>{{ $user['idnum'] }}</td>
                        <td>{{ $user['firstname'] }}</td>
                        <td>{{ $user['lastname'] }}</td>
                        <td>{{ $user['mobile'] }}</td>
                        <td>{{ $user['aff_code'] }}</td>
                        <td>{{ $user['referer'] !== null ? $user['referer'] : '-' }}</td>
                        <td><input class="text-center" name="credit" type="text" value="{{ $user['credit'] }}"></td>
                        <td class="ltr">{{ gregorianToJalali($user['created_at']) }}</td>
                        <td>
                            <select class="m-0" name="role">
                                <option value="10" {{ $user['role'] == 10 ? 'selected' : ''}}>ادمین</option>
                                <option value="30" {{ $user['role'] == 30 ? 'selected' : ''}}>کاربر</option>
                            </select>
                        </td>
                        <td><button class="btn btn-social-icon btn-circle btn-xs btn-info m-0" name="uid" value="{{ $user['id'] }}" type="submit"><i class="mdi mdi-content-save"></i></button></td>
                        </form>
                    </tr>
                @endforeach
                </tbody>
            </table>
    </div>
</div>
@endsection

@section('page-scripts')
<script src="{{ asset("statics/dash-template/vendor_components/datatable/datatables.min.js") }}"></script>
<script>
    var table = $('table').DataTable();
</script>
@endsection
