@extends("v1/02_dash-template/layouts/layout-customer")

@section("page-title") داشبورد @endsection

@section("page-body")
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="box">
                <div class="box-header with-border">
                    <h5 class="box-title">مشخصات کاربر</h5>
                    <ul class="box-controls pull-right">
                        <li><a class="box-btn-slide" href="#"></a></li>
                    </ul>
                </div>
                <div class="box-body">
                    <div class="box box-widget widget-user">
                        <div class="widget-user-header bg-black" style="background: url('<?= asset("statics/dash-template/images/gallery/full/10.jpg") ?>') center center;">
                            <h3 class="widget-user-username">{!! $user->firstname.' '.$user->lastname !!}</h3>
                            <h6 class="widget-user-desc">{!! $user->role == 30 ? 'کاربر اصلی' : 'کاربر زیر شاخه' !!}</h6>
                        </div>
                        <div class="widget-user-image">
                            <img class="rounded-circle" src="<?= asset("statics/dash-template/images/auth-bg.jpg") ?>" alt="User Avatar">
                        </div>
                        <div class="box-footer">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="description-block">
                                        <h5 class="description-header">کیف پول</h5>
                                        <span class="description-text">{!! convertNumbers($user->credit) !!} ریال</span>
                                    </div>
                                </div>
                                <div class="col-sm-4 br-1 bl-1">
                                    <div class="description-block">
                                        <h5 class="description-header">سرویس فعال</h5>
                                        <span class="description-text">۰</span>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="description-block">
                                        <h5 class="description-header">کد معرف</h5>
                                        <span class="description-text">{!! $user->aff_code !!}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="box">
                <div class="box-header with-border">
                    <h5 class="box-title">اطلاعیه ها</h5>
                    <ul class="box-controls pull-right">
                        <li><a class="box-btn-slide" href="#"></a></li>
                    </ul>
                </div>
                <div class="box-body">
                    <div class="alert alert-warning alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        هیچ اطلاعیه‌ای برای نمایش موجود نیست
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="box">
                <div class="box-header with-border">
                    <h5 class="box-title">سرویس های فعال</h5>
                    <ul class="box-controls pull-right">
                        <li><a class="box-btn-slide" href="#"></a></li>
                    </ul>
                </div>
                <div class="box-body">
                    <div class="alert alert-warning alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        شما هیچ سرویس فعالی ندارید
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
