@extends("v1/02_dash-template/layouts/layout-customer")

@section("page-title") تیکت ها @endsection

@section("page-body")
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">لیست تیکت ها</h3>
            <div class="pull-right">
                <button type="button" class="btn btn-sm btn-outline btn-secondary btn-rounded" data-toggle="modal" data-target="#ticket-form-modal">ایجاد تیکت جدید</button>
            </div>
        </div>
        <div class="box-body">
            <div class="mailbox-messages">
                <div class="table-responsive">
                    <table class="table text-center">
                        <thead>
                            <tr class="bg-pale-primary">
                                <th class="font-weight-bold col-1">شماره</th>
                                <th class="font-weight-bold col-2">موضوع</th>
                                <th class="font-weight-bold col-4">آخرین تغییرات</th>
                                <th class="font-weight-bold col-2">وضعیت تیکت</th>
                                <th class="font-weight-bold col-1">مشاهده</th>
                            </tr>
                        </thead>
                        <tbody>
                        @if (count($tickets) > 0)
                            @foreach($tickets as $ticket)
                                @if($ticket->status == 1)
                                    <tr class="bg-pale-secondary">
                                @elseif($ticket->seen_by_user == 1)
                                    <tr class="bg-pale-success">
                                @elseif($ticket->seen_by_operator == 1)
                                    <tr class="bg-pale-warning">
                                        @endif
                                        <td class="w-80">gmt-{{ $ticket->id }}</td>
                                        <td class="mailbox-subject">{{ $ticket->subject }}</td>
                                        <td class="ltr">{{ gregorianToJalali($ticket->created_at) }}</td>
                                        <td class="ltr">{{ $ticket->status == 0 ? ($ticket->seen_by_user ? 'باز - در انتظار پاسخ اپراتور' : 'باز - در انتظار پاسخ شما') : 'بسته' }}</td>
                                        <td class="">
                                            <a href="{{ route('ticket-single.view', $ticket->id) }}" class="btn btn-social-icon btn-circle btn-xs btn-light mr-2"><i class="mdi mdi-view-sequential"></i></a>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr class="bg-pale-secondary">
                                    <td colspan="5">شما هیچ تیکتی در سیستم ثبت نکرده‌اید</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-starter')
    <form action="./tickets" method="POST">
        @csrf
        <input type="hidden" name="action" value="create">
        <input type="hidden" name="siteuser" value="{{ auth()->user()->idnum }}">
        <div class="modal modal-left fade" id="ticket-form-modal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header justify-content-center">
                        <h4 class="modal-title font-weight-bold">ایجاد تیکت جدید</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> موضوع تیکت</h5>
                                    <div class="controls">
                                        <input name="subject" value="{{ old('subject') }}" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> شرح تیکت</h5>
                                    <div class="controls">
                                        <textarea name="content" class="form-control" rows="8">{{ old('content') }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer modal-footer-uniform">
                        <div class="row justify-content-center mt-2">
                            <div class="col-6">
                                <button id="submit-ticket" type="submit" class="btn btn-block btn-success">ثبت تیکت</button>
                            </div>
                            <div class="col-6">
                                <button type="button" class="btn btn-block btn-danger" data-dismiss="modal">بستن</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
