<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Favicons -->
    <link href="{{ asset('statics/img/gpumonsters-favicon.png') }}" rel="icon">
    <link href="{{ asset('statics/img/gpumonsters-favicon.png') }}" rel="apple-touch-icon">
    <title>پنل کاربری @yield('tab-title')</title>
    <link rel="stylesheet" href="{{ asset("statics/dash-template/vendor_components/bootstrap/dist/css/bootstrap.min.css") }}">
    <link rel="stylesheet" href="{{ asset("statics/dash-template/css/bootstrap-extend.css") }}">
    <link href="{{ asset('statics/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset("statics/dash-template/vendor_components/jquery-toast-plugin-master/src/jquery.toast.css") }}">
    <style>.jq-toast-single {font-family: var(--main-font-family)}</style>
    <link rel="stylesheet" href="{{ asset("statics/dash-template/css/master_style.css") }}">
    <link rel="stylesheet" href="{{ asset("statics/dash-template/css/skins/_all-skins.css") }}">
    @yield('page-styles')
</head>
<body class="skin-info-light fixed sidebar-mini rtl sidebar-mini-expand-feature" style="height: auto; min-height: 100%;">
@yield('page-starter')
<div class="wrapper">
    <header class="main-header">
        <a href="{{ route('home') }}" class="logo text-center">
            YourLogo
        </a>
        <nav class="navbar navbar-static-top">
            <a href="#" class="sidebar-toggle text-dark" data-toggle="push-menu" role="button">
                <span class="sr-only">Toggle navigation</span>
            </a>
            <form method="POST" action="{{ route('logout') }}" >
                @csrf
                <button class="btn btn-rounded btn-outline btn-danger exit-btn" type="submit">خروج</button>
            </form>
        </nav>
    </header>
    <aside class="main-sidebar">
        <section class="sidebar">
            <ul class="sidebar-menu" data-widget="tree">
                <li>
                    <a href="{{ route("dashboard.view") }}">
                        <i class="mdi mdi-view-dashboard"></i>
                        <span>داشبورد</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route("services.view") }}">
                        <i class="mdi mdi-buffer"></i>
                        <span>سرویس ها</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('orders.view') }}">
                        <i class="mdi mdi-cart"></i>
                        <span>سوابق خرید</span>
                    </a>
                </li>
                <li>
                    <a href="#">
                        <i class="mdi mdi-wallet"></i>
                        <span>کلیه تراکنش ها</span>
                    </a>
                </li>
{{--                <li>--}}
{{--                    <a href="#">--}}
{{--                        <i class="mdi mdi-folder-multiple"></i>--}}
{{--                        <span>مدیریت فایل ها</span>--}}
{{--                    </a>--}}
{{--                </li>--}}
                <li>
                    <a href="{{ route("tickets.view") }}">
                        <i class="mdi mdi-forum"></i>
                        <span>تیکت و پشتیبانی</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('edit-user-info.view') }}">
                        <i class="mdi mdi-account-edit"></i>
                        <span>ویرایش اطلاعات کاربری</span>
                    </a>
                </li>
            </ul>
        </section>
    </aside>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="d-flex align-items-center">
                <div class="mr-auto">
                    <h3 class="page-title">@yield("page-title")</h3>
                </div>
            </div>
        </div>
        <section class="content">
            @yield("page-body")
        </section>
    </div>
    <footer class="main-footer">
        <div class="pull-right d-none d-sm-inline-block">
            <ul class="nav nav-primary nav-dotted nav-dot-separated justify-content-center justify-content-md-end">
                <li class="nav-item">
                    <a href="https://ascode.ir/" class="nav-link">Designed with &#10084; by Me</a>
                </li>
            </ul>
        </div>
        &copy; تمامی حقوق این سایت متعلق به شتاب دهنده کاکتوس پارس می باشد
    </footer>
    <div class="control-sidebar-bg"></div>
</div>
<script src="<?= asset("statics/dash-template/vendor_components/jquery-3.3.1/jquery-3.3.1.js") ?>"></script>
<script src="<?= asset("statics/dash-template/vendor_components/popper/dist/popper.min.js") ?>"></script>
<script src="<?= asset("statics/dash-template/vendor_components/bootstrap/dist/js/bootstrap.min.js") ?>"></script>
<script src="<?= asset("statics/dash-template/vendor_components/jquery-slimscroll/jquery.slimscroll.min.js") ?>"></script>
<script src="<?= asset("statics/dash-template/vendor_components/fastclick/lib/fastclick.js") ?>"></script>
<script src="{{ asset("statics/dash-template/vendor_components/jquery-toast-plugin-master/src/jquery.toast.js") }}"></script>
<script src="<?= asset("statics/dash-template/js/template.js") ?>"></script>
@yield('page-scripts')
@if (count($errors->all()) > 0)
<script>
    var timer = 2000;
    @foreach ($errors->all() as $error)
        timer += 1500;
    $.toast({
        text: '{{ $error }}',
        position: 'bottom-left',
        loaderBg: '#ff6849',
        icon: 'error',
        textAlign: 'center',
        hideAfter: timer
    });
    @endforeach
</script>
@endif
@if(session()->has('msg'))
<script>
    $.toast({
        text: '{{ session('msg') }}',
        position: 'bottom-left',
        loaderBg: '#ff6849',
        icon: 'warning',
        textAlign: 'center',
        hideAfter: 3500
    });
</script>
@endif
</body>
</html>
