<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>GPUMonsters</title>
    <meta content="" name="description">

    <meta content="" name="keywords">

    <!-- Favicons -->
    <link href="{{ asset('statics/img/gpumonsters-favicon.png') }}" rel="icon">
    <link href="{{ asset('statics/img/gpumonsters-favicon.png') }}" rel="apple-touch-icon">

    <!-- Vendor CSS Files -->
    <link href="{{ asset('statics/vendor/aos/aos.css') }}" rel="stylesheet">
    <link href="{{ asset('statics/vendor/bootstrap/css/bootstrap.rtl.min.css') }}" rel="stylesheet">
    <link href="{{ asset('statics/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
    <link href="{{ asset('statics/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
    <link href="{{ asset('statics/vendor/remixicon/remixicon.css') }}" rel="stylesheet">
    <link href="{{ asset('statics/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">

    <!-- Template Main CSS File -->
    <link href="{{ asset('statics/css/style.css') }}" rel="stylesheet">
</head>

<body>

<!-- ======= Header ======= -->
<header id="header" class="header fixed-top">
    <div class="container-fluid container-xl d-flex align-items-center justify-content-between">
        <a href="{{ route('home') }}" class="logo d-flex align-items-center">
            <img src="{{ asset('statics/img/gpumonsters-logo.webp') }}" alt="">
        </a>
        <nav id="navbar" class="navbar justify-content-end">
            <ul>
                <li><a class="nav-link scrollto active" href="./#hero">خانه</a></li>
                <li><a class="nav-link scrollto" href="./#services">خدمات ما</a></li>
                <!--                <li><a class="nav-link scrollto" href="#pricing">سرویس ها</a></li>-->
                <li><a class="nav-link scrollto" href="./#about">درباره ما</a></li>
                <!--                <li><a class="nav-link scrollto" href="#faq">سوالات متداول</a></li>-->
                <li><a class="nav-link scrollto" href="./#contact">تماس با ما</a></li>

                @if (auth()->check())
                <li class="dropdown"><a href="#"><span>خوش آمدید!</span> <i class="bi bi-chevron-down"></i></a>
                    <ul class="text-center">
                        <li>
                            <i style="font-size: 50px;" class="bi bi-person-check"></i>
                            <p style="margin: -10px 0 10px;">{{ auth()->user()->firstname." ".auth()->user()->lastname }}</p>
                        </li>
                        <li>
                            <a href="{{ route('dashboard.view') }}" class="border-bottom"><i class="bi bi-speedometer2"></i> پنل کاربری</a>
                        </li>
                        @if (auth()->user()->role == 30)
                        <li>
                            <a href="#" class="border-bottom"><i class="bi bi-cart-check"></i> سوابق خرید</a>
                        </li>
                        <li>
                            <a href="#" class="border-bottom"><i class="bi bi-stack"></i> سرویس‌های فعال</a>
                        </li>
                        @endif
                        <li>
                            <a id="logout" href="#" style="padding-bottom: 4px !important;"><i class="bi bi-box-arrow-right"></i> خروج از حساب کاربری</a>
                        </li>
                    </ul>
                </li>
                @else
                <li class="login-li"><a class="login-btn scrollto" href="{{ route('login.view') }}">ورود | ثبت نام</a></li>
                @endif
            </ul>
            <i class="bi bi-list mobile-nav-toggle"></i>
        </nav><!-- .navbar -->
    </div>
</header>
<!-- End Header -->
@yield("page-body")

<!-- ======= Footer ======= -->
<footer id="footer" class="footer">

    <div class="footer-top">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-5 col-md-12 footer-info">
                    <a href="{{ route('home') }}" class="logo d-flex align-items-center">
                        <img src="{{ asset('statics/img/gpumonsters-logo.webp') }}" alt="">
                    </a>
                    {{ $homeItem['jumbotron-description'] }}
                    <div class="social-links mt-3">
                        <a href="#" class="twitter"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="facebook"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="instagram"><i class="bi bi-instagram"></i></a>
                        <a href="#" class="linkedin"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="telegram"><i class="bi bi-telegram"></i></a>
                    </div>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>مطالب پیشنهادی</h4>
                    <ul>
                        <li><i class="bi bi-chevron-left"></i> <a href="#">CPU Rendering</a></li>
                        <li><i class="bi bi-chevron-left"></i> <a href="#">GPU Rendering</a></li>
                        <li><i class="bi bi-chevron-left"></i> <a href="#">Remote Workstation</a></li>
                        <li><i class="bi bi-chevron-left"></i> <a href="#">راهنمای ثبت سفارش و پشتیبانی</a></li>
                    </ul>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>پیوند ها</h4>
                    <ul>
                        <!--                        <li><i class="bi bi-chevron-left"></i> <a href="#">یک عدد لینک</a></li>-->
                        <!--                        <li><i class="bi bi-chevron-left"></i> <a href="#">یک عدد لینک</a></li>-->
                        <!--                        <li><i class="bi bi-chevron-left"></i> <a href="#">یک عدد لینک</a></li>-->
                        <!--                        <li><i class="bi bi-chevron-left"></i> <a href="#">یک عدد لینک</a></li>-->
                    </ul>
                </div>

                <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
                    <h4>مجوز ها</h4>

                </div>

            </div>
        </div>
    </div>

    <div class="container">
        <div class="copyright">
            &copy; تمامی حقوق این سایت برای <strong><span>شتاب دهنده کاکتوس پارس</span></strong> محفوظ می‌باشد
        </div>
        <div class="credits">
            Coded with <i class="bi bi-heart-fill"></i> by <a href="https://linkedin.com/in/arian-sakhaei/">Arian Sakhaei</a>
        </div>
    </div>
</footer>
<!-- End Footer -->

<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>
<form id="logout-form" method="POST" action="{{ route('logout') }}" >@csrf</form>
<!-- Vendor JS Files -->
<script src="{{ asset('statics/vendor/purecounter/purecounter_vanilla.js') }}"></script>
<script src="{{ asset('statics/vendor/aos/aos.js') }}"></script>
<script src="{{ asset('statics/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('statics/vendor/glightbox/js/glightbox.min.js') }}"></script>
<script src="{{ asset('statics/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
<script src="{{ asset('statics/vendor/swiper/swiper-bundle.min.js') }}"></script>

<!-- Template Main JS File -->
<script src="{{ asset('statics/js/main.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script>
    $("#logout").bind('click', function () {
        $('#logout-form').submit();
    });
</script>
</body>

</html>

