<?php

use App\Http\Controllers\CouponController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MachineController;
use App\Http\Controllers\OrdersController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ServicesController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\CategoriesController;
use App\Http\Controllers\DashboardController;
//use App\Http\Controllers\LoginController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\TemplateController;
use App\Http\Controllers\UserFilesController;

use Illuminate\Support\Facades\Route;

/**
 * main template routes
 */
Route::get('/', [HomeController::class, 'index'])->name('home');

Route::middleware('guest')->controller(AuthController::class)->group(function () {
    Route::get('/login', 'viewLogin')->name('login.view');
    Route::post('/login', 'login')->name("login.submit");

    Route::get('/register', 'viewRegister')->name('register.view');
    Route::post('/register', 'register')->name('register.submit');

//    Route::get('/forget-password','viewForgetPassword')->name('forget-password.view');
//    Route::post('/forget-password','forgetPassword')->name('forget-password.submit');
});


/**
 * dash template routes
 */
Route::middleware('auth')->prefix('panel')->group(function() {
    Route::get('/dashboard', [DashboardController::class, 'viewProperDashboard'])->name('dashboard.view');

    Route::get('/template-settings', [TemplateController::class, 'viewTemplateSettings'])->name('template-settings.view');
    Route::post('/template-settings', [TemplateController::class, 'submitTemplateSettings'])->name('template-settings.submit');
    Route::post('/get-item-value', [TemplateController::class, 'fetchValue'])->name('get-item-value.submit');

    Route::get('/tickets', [TicketController::class, 'viewProperPage'])->name('tickets.view');
    Route::post('/tickets', [TicketController::class, 'handlePostRequest']);

    Route::get('/ticket/{id}', [TicketController::class, 'viewProperPage'])->name('ticket-single.view');
    Route::post('/ticket/{id}', [MessageController::class, 'createMessage']);

    Route::get('/categories', [CategoriesController::class, 'index'])->name('categories.view');
    Route::post('/categories', [CategoriesController::class, 'actionHandler'])->name('categories.action');

    Route::get('/edit-user-info', [UsersController::class, 'index'])->name('edit-user-info.view');
    Route::post('/edit-user-info', [UsersController::class, 'requestHandler'])->name('edit-user-info.submit');

    Route::get('/services',             [ServicesController::class, 'index'             ])->name('services.view');
    Route::get('/get-service',          [ServicesController::class, 'getServiceDetails' ])->name('service.get');
    Route::post('/services',            [ServicesController::class, 'addOrEditService'  ])->name('service.action');

    Route::get('/get-machine-status',   [MachineController::class, 'getMachineStatus'   ])->name('machine-status.get');
    Route::post('/machine-action',      [MachineController::class, 'machineCmdHandler'  ])->name('machine.action');

    Route::get('/orders', [OrdersController::class, 'index'])->name('orders.view');
    Route::get('/service/{id}', [OrdersController::class, 'viewOrderService'])->name('order-service.view');
    Route::get('/order-history/{id}', [OrdersController::class, 'viewOrderHistory'])->name('order-history.view');
    Route::get('/check-hourly-availability', [OrdersController::class, 'checkHourlyAvailability'])->name('check-hourly-availability.get');
    Route::post('/submit-order',        [OrdersController::class, 'submitOrder'])->name('submit-order.submit');
    Route::post('/change-order-status', [OrdersController::class, 'changeOrderStatus'])->name('change-order-status.submit');

    Route::get('payment/send-to-ipg/{oid}', [PaymentController::class, 'sendToIPG'])->name('dummy-payment.view');
//    Route::get('payment/ipg/{oid}', [PaymentController::class, 'sendToIPG'])->name('dummy-payment.view');
    Route::get('payment/callback', [PaymentController::class, 'processPayment'])->name('callback.view');
    Route::get('payments', [PaymentController::class, 'index'])->name('payments.view');

    Route::get('/coupon-management', [CouponController::class, 'index'])->name('coupon-management.view');
    Route::post('/coupon-management', [CouponController::class, 'editCouponPolicies'])->name('coupon-management.submit');
    Route::post('/create-coupon', [CouponController::class, 'createCoupon'])->name('create-coupon.submit');
    Route::post('/edit-coupon', [CouponController::class, 'editOrDeleteCoupon'])->name('edit-coupon.submit');
    Route::post('/coupon-usage', [CouponController::class, 'validateOrUseCoupon'])->name('coupon-usage.submit');

    Route::get('/file-management', [FileController::class, 'index'])->name('file-management.view');
    Route::post('/file', [FileController::class, 'addOrEditFile'])->name('file.submit');

    Route::get('/users-list', [UsersController::class, 'getUsersList'])->name('users.view');

    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});
