<?php $__env->startSection('tab-title'); ?>| لیست کاربران <?php $__env->stopSection(); ?>

<?php $__env->startSection("page-title"); ?>لیست کاربران سایت <?php $__env->stopSection(); ?>

<?php $__env->startSection("page-styles"); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset("statics/dash-template/vendor_components/datatable/datatables.min.css")); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("page-body"); ?>
<div class="box">
    <div class="box-body">
        <div class="table-responsive-sm">
            <table class="table table-hover table-bordered text-center">
                <thead>
                    <tr class="bg-pale-dark">
                        <th class="font-weight-bold col-1">کد ملی</th>
                        <th class="font-weight-bold col-1">نام</th>
                        <th class="font-weight-bold col-2">نام خانوادگی</th>
                        <th class="font-weight-bold col-2">شماره همراه</th>
                        <th class="font-weight-bold col-1">کد معرف</th>
                        <th class="font-weight-bold col-1">معرف</th>
                        <th class="font-weight-bold col-1">اعتبار</th>
                        <th class="font-weight-bold col-2">تاریخ عضویت</th>
                        <th class="font-weight-bold col-1">سطح</th>
                        <th class="font-weight-bold col-1">ذخیره</th>
                    </tr>
                </thead>
                <tbody class="text-sm">
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <form action="<?php echo e(route('edit-user-info.submit')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input name="action" value="change_user_data" type="hidden">
                        <td><?php echo e($user['idnum']); ?></td>
                        <td><?php echo e($user['firstname']); ?></td>
                        <td><?php echo e($user['lastname']); ?></td>
                        <td><?php echo e($user['mobile']); ?></td>
                        <td><?php echo e($user['aff_code']); ?></td>
                        <td><?php echo e($user['referer'] !== null ? $user['referer'] : '-'); ?></td>
                        <td><input class="text-center" name="credit" type="text" value="<?php echo e($user['credit']); ?>"></td>
                        <td class="ltr"><?php echo e(gregorianToJalali($user['created_at'])); ?></td>
                        <td>
                            <select class="m-0" name="role">
                                <option value="10" <?php echo e($user['role'] == 10 ? 'selected' : ''); ?>>ادمین</option>
                                <option value="30" <?php echo e($user['role'] == 30 ? 'selected' : ''); ?>>کاربر</option>
                            </select>
                        </td>
                        <td><button class="btn btn-social-icon btn-circle btn-xs btn-info m-0" name="uid" value="<?php echo e($user['id']); ?>" type="submit"><i class="mdi mdi-content-save"></i></button></td>
                        </form>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
<script src="<?php echo e(asset("statics/dash-template/vendor_components/datatable/datatables.min.js")); ?>"></script>
<script>
    var table = $('table').DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("v1/02_dash-template/layouts/layout-admin", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gpumonster\core\resources\views/v1/02_dash-template/admin-pages/users-list.blade.php ENDPATH**/ ?>