<?php get_header();?>
<main id="main">
    <!-- ======= Breadcrumbs ======= -->
	<?php  if(have_posts()) : ?>
    <section class="breadcrumbs">
        <div class="container">
            <ol>
                <li><a href="#">خانه</a></li>
                <li><a href="<?= get_site_url(); ?>">خواندنی ها</a></li>
                <li><a href="<?= get_site_url(); ?>/category/<?= get_the_category(get_the_ID())[0]->slug ?>"><?= get_the_category(get_the_ID())[0]->name ?></a></li>
            </ol>
            <h2><?php the_title(); ?></h2>
        </div>
    </section>
    <!-- End Breadcrumbs -->
    <!-- ======= Blog Single Section ======= -->
    <section id="blog" class="blog">
        <div class="container" data-aos="fade-up">
            <div class="row">
                <div class="col-lg-8 entries">
                    <article class="entry entry-single">
                        <div class="entry-img">
                            <img src="<?php the_post_thumbnail_url(); ?>" alt="" class="img-fluid">
                        </div>
                        <h2 class="entry-title">
                            <a href="#"><?php the_title(); ?></a>
                        </h2>
                        <div class="entry-meta">
                            <ul>
                                <li class="d-flex align-items-center"><i class="bi bi-person"></i> <a href="#"><?php the_modified_author(); ?></a></li>
                                <li class="d-flex align-items-center"><i class="bi bi-clock"></i> <a href="#"><time datetime="<?= get_the_date() ?>"><?= get_the_date() ?></time></a></li>
                            </ul>
                        </div>
                        <div class="entry-content"><?php the_content(); ?></div>
                    </article>
                    <!-- End blog entry -->
                </div>
                <!-- End blog entries list -->
                <div class="col-lg-4">
                    <div class="sidebar">
                        <h3 class="sidebar-title">جستجو</h3>
                        <div class="sidebar-item search-form">
                            <form action="">
                                <input type="text">
                                <button type="submit"><i class="bi bi-search"></i></button>
                            </form>
                        </div>
                        <!-- End sidebar search formn-->
                        <h3 class="sidebar-title">دسته بندی ها</h3>
                        <div class="sidebar-item categories">
                            <ul>
                            <?php
                            $args = array(
                                'orderby' => 'slug',
                                'parent' => 0
                            );
                            $categories = get_categories( $args );
                            foreach( $categories as $category )
                                echo '<li><a href="'.get_site_url().'/category/'.$category->slug.'">'. $category->name .' <span>('. $category->category_count .')</span></a></li>';
                            ?>
                            </ul>
                        </div>
                        <!-- End sidebar categories-->
                        <h3 class="sidebar-title">تگ ها</h3>
                        <div class="sidebar-item tags">
                            <ul>
                            <?php
                            $tags = get_the_tags(get_the_ID());
                            foreach ($tags as $tag) :
                            ?>
                            <li><a href="<?= get_site_url(); ?>/tag/<?= $tag->slug ?>"><?= $tag->name ?></a></li>
                            <?php endforeach; ?>
                            </ul>
                        </div>
                        <!-- End sidebar tags-->
                    </div>
                    <!-- End sidebar -->
                </div>
                <!-- End blog sidebar -->
            </div>
        </div>
    </section>
    <!-- End Blog Single Section -->
<?php endif; ?>
</main>
<!-- End #main -->
<?php get_footer();?>
</body>
</html>