<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\TemplateItem;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\URL;

class HomeController extends Controller
{
    /**
     * @var bool
     */
    private bool $api_call;
    /**
     * @var array
     */
    public $homeItems = [];
    /**
     * @brief
     * collect homepage data and assign to $homeItems array
     * assign true|false to $api_call by checking if the request is an API call
     *
     * @return void
     */
    function __construct() {
        /**
         * fetching homepage data
         */
        $response = Http::get(URL::full()."/blog/wp-json/wp/v2/posts", [
            'status' => 'publish',
            'per_page' => 3,
            '_embed' => '',
        ]);
        $latestBlogPosts   = json_decode($response, JSON_UNESCAPED_UNICODE);
        $itemsIndexedArray = TemplateItem::all();
        $this->homeItems['blog-posts'] = $latestBlogPosts;
        foreach ($itemsIndexedArray as $item)
            $this->homeItems[$item['item_key']] = $item['item_value'];

        $this->homeItems['services'] = Service::join('categories', 'services.category_id', '=', 'categories.id')
                                       ->select('services.id as sid', 'services.title as s_title', 'categories.title as c_title', 'icon', 'hourly_rate', 'daily_rate', 'quantity_per_day as qpd', 'excerpt', 'description')
                                       ->where('stared', "=", "1")
                                       ->get();
        /**
         * checking if the request is an API call
         */
        $this->api_call = request()->header('Accept') == "application/json";
    }
    function index() {
        return !$this->api_call ?
            view('v1.03_main-template.home', ['homeItem'=>$this->homeItems]) :
            successfulResponse($this->homeItems);
    }
}
