<?php

namespace App\Http\Controllers;

use App\Models\Message;
use App\Models\Ticket;
use Illuminate\Http\Request;

class MessageController extends Controller
{
    public function createMessage()
    {
        $user = auth()->user();
        request()->validate([
            'tid' => 'required|numeric',
            'message' => 'required|between:5,250'
        ], [
            'message.required' => 'فیلد متن پیام الزامی است',
            'message.between' => 'پیام باید بین ۵ تا ۲۵۰ کاراکتر باشد',
            'tid.numeric' => 'ورودی ها نامعتبر',
            'tid.required' => 'ورودی ها نامعتبر',
        ]);
        $ticket  = Ticket::find(request('tid'));
        $message = new Message;

        $message->ticket_id = request('tid');
        $message->content = request('message');
        if ($user->role == 10) {
            $message->direction = 0;
            $ticket->seen_by_user = 0;
            $ticket->seen_by_operator = 1;
        } else {
            $message->direction = 1;
            $ticket->seen_by_user = 1;
            $ticket->seen_by_operator = 0;
        }
        $ticket->save();
        $message->save();
        return back()->with('msg', 'پیام با موفقیت ارسال شد');
    }
}
