<?php

namespace App\Http\Controllers;

use App\Models\Message;
use App\Models\Ticket;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class TicketController extends Controller
{
    protected $user;
    public function __construct() {
        $this->user = auth()->user();
    }
    public function viewProperPage($id = 0) {
        $middle_route = isAdmin() ? 'admin-pages' : 'customer-pages';
        if ($id === 0) {
            $tickets = isAdmin() ?
                Ticket::join('users', 'tickets.user_id', '=', 'users.id')->orderby('created_at', 'desc')->get(['tickets.*', 'users.firstname', 'users.lastname']) :
                Ticket::where('user_id', auth()->user()->id)->orderby('created_at', 'desc')->get();
            return view("v1/02_dash-template/$middle_route/tickets", ["tickets"=>$tickets]);
        }
        else {
            $messages = Message::join('tickets', 'messages.ticket_id', '=', 'tickets.id')->where('ticket_id', $id)->get(['messages.*']);
            $ticket   = Ticket::join('users', 'tickets.user_id', '=', 'users.id')->where('tickets.id', '=', $id)->get(['tickets.*', 'users.firstname', 'users.lastname']);
            return view("v1/02_dash-template/$middle_route/ticket-single", ['messages'=>$messages, 'ticket'=>$ticket[0], 'tid'=>$id]);
        }
    }
    public function handlePostRequest() {
        if (request()->has('action')) {
            switch (request('action')) {
                case 'create':
                    $this->createNewTicket();
                    return back()->with('msg', 'تیکت با موفقیت ایجاد شد');
                case 'close':
                    $this->closeTicket();
                    return back()->with('msg', 'تیکت با موفقیت بسته شد');
                default:
                    abort(404);
            }
        } else {
            abort(406);
        }
    }
    public function createNewTicket() {
//        dd(request());
        request()->validate([
            'subject'=>'required',
            'content'=>'required',
            'siteuser'=>'required|numeric|exists:users,idnum'
        ],[
            'subject.required' => 'فیلد موضوع تیکت الزامی می‌باشد',
            'content.required' => 'فیلد شرح تیکت الزامی می‌باشد',
            'siteuser.exists' => 'کاربر نامعتبر',
            'siteuser.numeric' => 'فیلد شناسه کاربر نامعتبر',
            'siteuser.required' => 'فیلد شناسه کاربر الزامی می‌باشد'
        ]);
        $ticket = new Ticket;
        $ticket->user_id = User::where('idnum', request('siteuser'))->get('id')->last()->id;
        $ticket->subject = request('subject');
        if (auth()->user()->role == 10) {
            $ticket->seen_by_user     = 0;
            $ticket->seen_by_operator = 1;
        } else {
            $ticket->seen_by_user     = 1;
            $ticket->seen_by_operator = 0;
        }
        $ticket->save();
        $message = new Message;
        $message->ticket_id = $ticket->id;
        $message->content = request('content');;
        $message->direction = isAdmin() ? 0 : 1;
        $message->save();
    }
    public function closeTicket() {
        $user = auth()->user();
        if ($user->role == 10) {
            $ticket = Ticket::find(request('tid'));
            $ticket->status = 1;
            $ticket->save();
        } else
            abort(401);
    }
}
