<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class OTPRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'type' => 'required|string',
            'idnum' => 'required|ir_national_code',
            'mobile' => 'required|ir_mobile:zero',
        ];
    }
    /**
     * Set proper error messages for failed validations
     *
     * @return array<string>
     */
    public function messages() {
        return [
            'mobile.ir_mobile' => 'تلفن همراه وارد شده نامعتبر می‌باشد',
            'idnum.ir_national_code' => 'کد ملی وارد شده نامعتبر می‌باشد',
        ];
    }
    /**
     * @param Validator $validator
     *
     * @return [json]
     */
    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json($validator->errors(), 400));
    }
}
