<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\Rules\Password;

class RegisterRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'firstname'=>'required|persian_alpha|between:2,40',
            'lastname'=>'required|persian_alpha|between:2,40',
            'mobile'=>'required|unique:users,mobile|ir_mobile:zero',
            'idnum'=>'required|unique:users,idnum|ir_national_code',
            'email'=>'required|unique:users,email|email',
            'type'=>'required|string',
            'otpval'=>'nullable|min:6|numeric',
            'password' => [
                'required',
                Password::min(8)->letters()
            ],
            'password_confirmation'=>'required|same:password'
        ];
    }
    /**
     * Set proper error messages for failed validations
     *
     * @return array<string>
     */
    public function messages() {
//        $headers = apache_request_headers();
//        if ($headers['Accept'] != "application/json") {
//            return [
//                'firstname.persian_alpha' => 'فقط کاراکترهای فارسی قابل قبول می‌باشد',
//                'lastname.persian_alpha' => 'فقط کاراکترهای فارسی قابل قبول می‌باشد',
//                'mobile.ir_mobile' => 'تلفن همراه وارد شده نامعتبر می‌باشد',
//                'idnum.ir_national_code' => 'کد ملی وارد شده نامعتبر می‌باشد',
//                'type.string' => 'درخواست نامعتبر',
//                'type.required' => 'درخواست نامعتبر',
//            ];
//        } else {
//            throwBadRequestError(['errors' => ['ورودی ها نامعتبر']]);
//        }
        return [
            'firstname.persian_alpha' => 'فقط کاراکترهای فارسی قابل قبول می‌باشد',
            'lastname.persian_alpha' => 'فقط کاراکترهای فارسی قابل قبول می‌باشد',
            'mobile.ir_mobile' => 'تلفن همراه وارد شده نامعتبر می‌باشد',
            'idnum.ir_national_code' => 'کد ملی وارد شده نامعتبر می‌باشد',
            'type.string' => 'درخواست نامعتبر',
            'type.required' => 'درخواست نامعتبر',
        ];
    }
}
