<?php

namespace App\Http\Requests;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class addOrEditServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->user()->role == 10;
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'id'=>'numeric|exists:services,id',
            'title'=>'required|between:5,250',
            'category_id'=>'required|numeric|exists:categories,id',
            'parent_id'=>'nullable|numeric',
            'children_ids'=>'array',
            'children_ids.*'=>'nullable|numeric',
            'daily_rate'=>'required|numeric',
            'hourly_rate'=>'required|numeric',
            'quantity' => 'required|numeric',
            'stared' => 'boolean',
            'excerpt' => 'required|string',
            'details' => 'required|string',
            'mid'=>'nullable|string',
        ];
    }
}
