@extends("v1/02_dash-template/layouts/layout-admin")

@section("page-title") داشبورد @endsection

@section("page-body")
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="box">
                <div class="box-header with-border">
                    <h5 class="box-title">وضعیت تیکت ها</h5>
                    <ul class="box-controls pull-right">
                        <li><a class="box-btn-slide" href="#"></a></li>
                    </ul>
                </div>
                <div class="box-body">
                    <div class="row" style="margin-bottom: -30px">
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-info mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-ticket-confirmation font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($tickets['sum'], "EnToFa") }}</div>
                                    <span>مجموع</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-warning mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-message-reply-text font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($tickets['answered'], "EnToFa") }}</div>
                                    <span>پاسخ داده شده</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-success mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-thumb-up-outline font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($tickets['closed'], "EnToFa") }}</div>
                                    <span>بسته شده</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-danger mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-ticket font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($tickets['awaiting'], "EnToFa") }}</div>
                                    <span>در انتظار پاسخ</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="box">
                <div class="box-header with-border">
                    <h5 class="box-title">وضعیت سفارشات</h5>
                    <ul class="box-controls pull-right">
                        <li><a class="box-btn-slide" href="#"></a></li>
                    </ul>
                </div>
                <div class="box-body">
                    <div class="row" style="margin-bottom: -30px">
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-info mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-cart-plus font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($order['sum']) }}</div>
                                    <span>مجموع</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-warning mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-timer-sand font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($order['reserved']) }}</div>
                                    <span>در انتظار تایید</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-success mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-thumb-up-outline font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($order['done']) }}</div>
                                    <span>تایید شده</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 col-12">
                            <div class="flexbox flex-justified text-center bg-danger mb-30 pull-up">
                                <div class="no-shrink py-30">
                                    <span class="mdi mdi-thumb-down-outline font-size-50"></span>
                                </div>
                                <div class="py-30 bg-light text-dark">
                                    <div class="font-size-30 countnm">{{ convertNumbers($order['cancelled']) }}</div>
                                    <span>لغو شده</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
