@extends("v1/02_dash-template/layouts/layout-admin")

@section('tab-title')| تیکت [{{ convertNumbers($tid, "EnToFa") }}] @endsection

@section("page-title") تیکت شماره {{ convertNumbers($tid, "EnToFa") }} @endsection

@section("page-info") وضعیت: {{ $ticket->status == 0 ? 'باز' : 'بسته' }} @endsection

@section("page-styles")
<style>.slimScrollDiv{height: 400px !important;} .chat-app {height: 400px !important;}</style>
@endsection

@section("page-body")
    <section class="content">
        <div class="box direct-chat">
            <div class="box-header with-border bg-lighter">
                <h4 class="box-title">موضوع: {{ $ticket->subject }}</h4>
            </div>
            <div class="box-body">
                <div id="chat-app" class="direct-chat-messages chat-app">
                    @foreach($messages as $message)
                        @if ($message->direction == 0)
                            <div class="direct-chat-msg right mb-30">
                                <div class="clearfix mb-0">
                                    <span class="direct-chat-name pull-right">مدیر سایت</span>
                                </div>
                                <div class="direct-chat-text">
                                    <p>{{ $message->content }}</p>
                                    <p class="direct-chat-timestamp text-muted ltr">{{ gregorianToJalali($message->datetime) }}</p>
                                </div>
                            </div>
                        @else
                            <div class="direct-chat-msg mb-30">
                                <div class="clearfix mb-0">
                                    <span class="direct-chat-name">{{ $ticket->firstname.' '.$ticket->lastname }}</span>
                                </div>
                                <div class="direct-chat-text">
                                    <p>{{ $message->content }}</p>
                                    <p class="direct-chat-timestamp text-muted ltr">{{ gregorianToJalali($message->datetime) }}</p>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
            @if ($ticket->status == 0)
            <div class="box-footer">
                <form action="#" method="POST">
                    @csrf
                    <input type="hidden" name="tid" value="{{ $ticket->id }}">
                    <div class="input-group">
                        <input type="text" name="message" placeholder="تایپ کنید ..." class="form-control">
                        <div class="input-group-addon">
                            <div class="align-self-end gap-items">
                                <button type="submit" class="publisher-btn" href="#"><i class="fa fa-paper-plane"></i></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            @endif
        </div>
    </section>
@endsection

@section("page-scripts")
<script>
    $(document).ready(function() {
        $('#chat-app').scrollTop($('#chat-app').height());
    })
</script>
@endsection
