@extends("v1/02_dash-template/layouts/layout-customer")

@section('tab-title')| سفارشات @endsection

@section("page-title") سفارشات @endsection

@section('page-styles')
<link rel="stylesheet" type="text/css" href="{{ asset("statics/dash-template/vendor_components/datatable/datatables.min.css") }}"/>
<style>
    table {
        cursor: default !important;
    }
</style>
@endsection

@section("page-body")
    <div class="box">
        <div class="box-body">
            <div class="table-responsive">
                <table class="table table-sm table-bordered text-center">
                    <thead>
                    <tr class="bg-pale-dark">
                        <th class="font-weight-bold">#</th>
                        <th class="font-weight-bold">شناسه</th>
                        <th class="font-weight-bold">سرویس</th>
                        <th class="font-weight-bold">نوع</th>
                        <th class="font-weight-bold">حجم</th>
                        <th class="font-weight-bold">تاریخ ثبت</th>
                        <th class="font-weight-bold">تاریخ پرداخت</th>
                        <th class="font-weight-bold">وضعیت</th>
                    </tr>
                    </thead>
                    <tbody>
                    @php $counter = 1 @endphp
                    @foreach($orders as $order)
                        <tr>
                            <td>{{ $counter }}</td>
                            <td>gpum-{{ $order->id }}</td>
                            <td>{{ $order->title }}</td>
                            <td>{{ is_null($order->hours) ? "روزانه" : "ساعتی" }}</td>
                            <td>{{ is_null($order->hours) ? gregorianToJalali($order->from).' الی '.gregorianToJalali($order->until) : $order->hours }}</td>
                            <td class="ltr">{{ gregorianToJalali($order->placement_datetime, "Y/m/d H:i") }}</td>
                            <td class="ltr">{{ is_null($order->callback_datetime) ? "-" : gregorianToJalali($order->callback_datetime, "Y/m/d H:i") }}</td>
                            <td class="ltr">{{ $order->status }}</td>
                        </tr>
                        @php $counter++ @endphp
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('page-scripts')
    <script src="{{ asset("statics/dash-template/vendor_components/datatable/datatables.min.js") }}"></script>
    <script>
        var table = $('table').DataTable();
    </script>
@endsection
