@extends("v1/02_dash-template/layouts/layout-customer")

@section("tab-title") | رزرو سرویس@endsection

@section("page-title"){{ $service['title'] }}@endsection

@section("page-styles")
<link rel="stylesheet" href="{{ asset("statics/dash-template/vendor_components/select2/dist/css/select2.css") }}">
<style>
.pdp .pdp-group .pdp-icon {
    padding: 0.45rem 0.70rem !important;
}
.pdp-input {
    height: 38px !important;
}
.select2-selection {
    border-radius: 5px !important;
}
.select2-selection__choice {
    /*background-color: #2962FF !important;*/
    background-color: var(--secondary) !important;
}
table {
    cursor: default !important;
}
</style>
@endsection

@section("page-body")
<div class="box">
    <div class="box-body">
        <ul class="nav nav-tabs justify-content-center" role="tablist">
            <li class="nav-item mr-1"> <a class="nav-link active" data-toggle="tab" href="#service-desc" role="tab">مشخصات سرویس</a> </li>
            <li class="nav-item mr-1"> <a class="nav-link" data-toggle="tab" href="#hourly-reservation" role="tab">رزرو ساعتی</a></li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#daily-reservation" role="tab">رزرو روزانه</a> </li>
        </ul>
        <div class="tab-content tabcontent-border">
            <div class="tab-pane active" id="service-desc" role="tabpanel">
                <div class="pad">
                    {!! $service->description !!}
                </div>
            </div>
            @php
            $disableString = "";
            $currentHour        = date('H');
			$currentJalaliDay   = gregorianToJalali(date("Y-m-d"), 'd', 'en');
			$currentJalaliMonth = gregorianToJalali(date("Y-m-d"), 'm', 'en');
			$currentJalaliYear  = gregorianToJalali(date("Y-m-d"), 'Y', 'en');
			for ($i = 1; $i < $currentJalaliDay; $i++)
                $disableString .= "'$currentJalaliYear/$currentJalaliMonth/$i', ";

            $hourlyDisableStr = $disableString;
			foreach ($do as $d)
                $hourlyDisableStr .= "'$d', ";

			$dailyDisableStr = $disableString;
			foreach ($ao as $a)
                $dailyDisableStr .= "'$a', ";
            @endphp
            <div class="tab-pane fade pad" id="hourly-reservation" role="tabpanel">
                <form action="{{ route('submit-order.submit') }}" method="post">
                    @csrf
                    <input name="sid" value="{{ $service['id'] }}" type="hidden">
                    <input name="type" value="hourly" type="hidden">
                    <input id="date" name="date" type="hidden">
                    <input id="pph" name="pph" type="hidden">
                    <div class="row">
                        <div class="col-12 col-md-3" id="persian-datepicker-1">
                            <date-picker color="purple" mode="single" :disable="[{!! $hourlyDisableStr !!}]" @select="select" placeholder="ابتدا تاریخ را انتخاب کنید"></date-picker>
                        </div>
                        <div class="col-12 col-md-2">
                            <p id="preloader" class="d-none text-secondary text-center" style="margin-top: 10px">لطفا کمی تامل فرمایید...</p>
                            <div id="times" class="form-group">
                                <select class="form-control select2 select2-hidden-accessible rtl" name="times[]" multiple="" style="width: 100%; " tabindex="-1" aria-hidden="true" disabled>
                                @for($i = 0; $i < 24; $i++)
                                    @if ($i < 10)
                                        <option id="{{ $i }}" value="{{ $i }}">0{{ $i }}:00</option>
                                    @else
                                        <option id="{{ $i }}" value="{{ $i }}">{{ $i }}:00</option>
                                    @endif
                                @endfor
                                </select>
                            </div>
                        </div>
                        <div class="col-12 col-md-7">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="bg-secondary">
                                        <tr>
                                            <th class="text-center">حجم سرویس</th>
                                            <th class="text-center">نرخ پایه</th>
                                            <th class="text-center">مجموع</th>
                                            <th class="text-center">مالیات و عوارض</th>
                                            <th class="text-center">مبلغ قابل پرداخت</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td id="count" class="text-center">-</td>
                                            <td class="text-center">{{ convertNumbers(number_format($service['hourly_rate'], 0, '', '٫')) }}</td>
                                            <td id="sum" class="text-center">-</td>
                                            <td id="tax" class="text-center">-</td>
                                            <td id="total" class="text-center">-</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-12 text-center">
                            <button id="hourly-submit-btn" class="btn btn-primary" type="submit" disabled>پرداخت و رزرو سرویس</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="tab-pane fade pad" id="daily-reservation" role="tabpanel">
                <form action="{{ route('submit-order.submit') }}" method="post">
                    @csrf
                    <input name="type" value="daily" type="hidden">
                    <input name="sid" value="{{ $service['id'] }}" type="hidden">
                    <input id="from" name="from" type="hidden">
                    <input id="until" name="until" type="hidden">
                    <input id="ppd" name="ppd" type="hidden">
                    <div class="row">
                        <div class="col-4" id="persian-datepicker-2">
                            <date-picker color="purple" mode="range" @submit="submit" :disable="[{!! $dailyDisableStr !!}]"></date-picker>
                        </div>
                        <div class="col-12 col-md-8">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="bg-secondary">
                                    <tr>
                                        <th class="text-center">حجم سرویس</th>
                                        <th class="text-center">نرخ پایه</th>
                                        <th class="text-center">مجموع</th>
                                        <th class="text-center">مالیات و عوارض</th>
                                        <th class="text-center">مبلغ قابل پرداخت</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td id="d-count" class="text-center">-</td>
                                        <td class="text-center">{{ convertNumbers(number_format($service['daily_rate'], 0, '', '٫')) }}</td>
                                        <td id="d-sum" class="text-center">-</td>
                                        <td id="d-tax" class="text-center">-</td>
                                        <td id="d-total" class="text-center">-</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-12 text-center">
                            <button id="daily-submit-btn" class="btn btn-primary" type="submit" disabled>پرداخت و رزرو سرویس</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('page-scripts')
<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@alireza-ab/vue-persian-datepicker@2.3.0/dist/datepicker.min.js"></script>
<script src="{{ asset("statics/dash-template/vendor_components/select2/dist/js/select2.full.js") }}"></script>
<script>
    const baseDailyRate = {{ $service['daily_rate'] }};
    const baseHourlyRate = {{ $service['hourly_rate'] }};
    const selectElement = $('.select2');
    $(document).ready(function() {
        var timeArray = ["00"];
        selectElement.select2({
            placeholder: 'ساعات قابل دسترس',
            dir: "rtl",
            closeOnSelect: false,
        });
        new Vue({
            el:'#persian-datepicker-1',
            components:{
                datePicker
            },
            methods: {
                select(date) {
                    var shamsiDate = date.toString();
                    $('#date').val(shamsiDate);
                    $.ajax({
                        url: '{{ route('check-hourly-availability.get') }}',
                        method: 'GET',
                        data: {
                            sid: {{  $service['id'] }},
                            date: shamsiDate
                        },
                        beforeSend: function () {
                            $('#times').addClass('d-none');
                            $('#preloader').removeClass('d-none');
                            for (let i = 0; i < 24; i++) {
                                $('#' + i).prop('disabled', false);
                                console.log(i + " enabled");
                            }
                        },
                        success: function(response) {
                            let idsToDisable = JSON.parse(response);

                            idsToDisable.forEach(function(id) {
                                $('#' + id).prop('disabled', true);
                                console.log(id + ' disabled');
                            });

                            selectElement.prop("disabled", false);
                            selectElement.prop("required", true);
                        },
                        error: function(xhr, status, error) {
                            console.log(error);
                        },
                        complete: function () {
                            $('#times').removeClass('d-none');
                            $('#preloader').addClass('d-none');
                        }
                    });
                }
            }
        });
        new Vue({
            el:'#persian-datepicker-2',
            components:{
                datePicker
            },
            methods: {
                submit(date) {
                    let from  = date[0];
                    let until = date[1];
                    $('#from').val(from.toString());
                    $('#until').val(until.toString());
                    let count = until.diff(from, 'date') + 1;
                    let sum   = count * baseDailyRate;
                    let tax   = sum * 0.09;
                    let total = tax + sum;
                    $('#ppd').val(total);
                    $('#d-count').text(convertNumbers(count) + ' روز');
                    $('#d-sum').text(convertNumbers(numberFormat(sum)));
                    $('#d-tax').text(convertNumbers(numberFormat(tax)));
                    $('#d-total').text(convertNumbers(numberFormat(total)) + ' ریال');
                    count > 0 ? $('#daily-submit-btn').prop('disabled', false) : $('#daily-submit-btn').prop('disabled', true);
                },
            }
        });
        selectElement.on('change', function () {
            let selectElementValues = selectElement.val();
            let count = selectElementValues.length;
            let sum   = count * baseHourlyRate;
            let tax   = sum * 0.09;
            let total = tax + sum;
            $('#pph').val(total);
            $('#count').text(convertNumbers(count) + ' ساعت');
            $('#sum').text(convertNumbers(numberFormat(sum)));
            $('#tax').text(convertNumbers(numberFormat(tax)));
            $('#total').text(convertNumbers(numberFormat(total)) + ' ریال');
            count > 0 ? $('#hourly-submit-btn').prop('disabled', false) : $('#hourly-submit-btn').prop('disabled', true);
        })
    });
</script>
@endsection
