<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is the API routes for the application.
| These routes are loaded by the RouteServiceProvider and
| all of them will be assigned to the "api" middleware group.
*/
use App\Http\Controllers\CouponController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\OrdersController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ServicesController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\CategoriesController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\TemplateController;
use App\Http\Controllers\UserFilesController;
/**
 * public API routes
 * - login
 * - register
 * - forget password
 * - homepage
 */
Route::get('get-homepage-content', [HomeController::class, 'index'])->name('home.get');
Route::controller(AuthController::class)->group(function () {
    Route::post('login'           , 'login'   );
    Route::post('refresh'         , 'refresh' );
    Route::post('register'        , 'register');
    Route::post('forget-password' , 'refresh' );
});
/**
 * Auth required routes, only available to fetch user level data
 * will respond 403 for admin access level data
 */
Route::middleware('auth:api')->group(function() {
    Route::get('/get-dashboard-content', [DashboardController::class, 'viewProperDashboard'    ]);
    Route::get('/get-services'         , [ServicesController::class , 'index'                  ]);
    Route::get('/get-service-details'  , [OrdersController::class   , 'viewOrderService'       ]);
    Route::get('/get-orders'           , [OrdersController::class   , 'index'                  ]);
    Route::get('/hourly-availability'  , [OrdersController::class   , 'checkHourlyAvailability']);
    Route::post('/submit-order'        , [OrdersController::class   , 'submitOrder'            ]);
    Route::post('/validate-coupon'     , [CouponController::class   , 'validateCoupon'         ]);
    Route::get('/ipg-callback'         , [PaymentController::class  , 'processPayment'         ]);
    Route::get('/get-payments'         , [PaymentController::class  , 'index'                  ]);
//    Route::get('/get-user-files'       , [UserFilesController::class, 'index'                  ]);
    Route::get('/tickets'              , [TicketController::class   , 'viewProperPage'         ]);
    Route::post('/tickets'             , [TicketController::class   , 'handlePostRequest'      ]);
    Route::get('/ticket'               , [TicketController::class   , 'viewProperPage'         ]);
    Route::post('/ticket'              , [MessageController::class  , 'createMessage'          ]);
    Route::post('/edit-user-info'      , [UsersController::class    , 'requestHandler'         ]);

    Route::post('logout-may', [AuthController::class, 'logout']);
});
