<?php $__env->startSection('tab-title'); ?>| سفارشات <?php $__env->stopSection(); ?>

<?php $__env->startSection("page-title"); ?> سفارشات <?php $__env->stopSection(); ?>

<?php $__env->startSection('page-styles'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset("statics/dash-template/vendor_components/datatable/datatables.min.css")); ?>"/>
<style>
    table {
        cursor: default !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("page-body"); ?>
    <div class="box">
        <div class="box-body">
            <div class="table-responsive">
                <table class="table table-sm table-bordered text-center">
                    <thead>
                    <tr class="bg-pale-dark">
                        <th class="font-weight-bold">#</th>
                        <th class="font-weight-bold">شناسه</th>
                        <th class="font-weight-bold">سرویس</th>
                        <th class="font-weight-bold">نوع</th>
                        <th class="font-weight-bold">حجم</th>
                        <th class="font-weight-bold">تاریخ ثبت</th>
                        <th class="font-weight-bold">تاریخ پرداخت</th>
                        <th class="font-weight-bold">وضعیت</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $counter = 1 ?>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($counter); ?></td>
                            <td>gpum-<?php echo e($order->id); ?></td>
                            <td><?php echo e($order->title); ?></td>
                            <td><?php echo e(is_null($order->hours) ? "روزانه" : "ساعتی"); ?></td>
                            <td><?php echo e(is_null($order->hours) ? gregorianToJalali($order->from).' الی '.gregorianToJalali($order->until) : $order->hours); ?></td>
                            <td class="ltr"><?php echo e(gregorianToJalali($order->placement_datetime, "Y/m/d H:i")); ?></td>
                            <td class="ltr"><?php echo e(is_null($order->callback_datetime) ? "-" : gregorianToJalali($order->callback_datetime, "Y/m/d H:i")); ?></td>
                            <td class="ltr"><?php echo e($order->status); ?></td>
                        </tr>
                        <?php $counter++ ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <script src="<?php echo e(asset("statics/dash-template/vendor_components/datatable/datatables.min.js")); ?>"></script>
    <script>
        var table = $('table').DataTable();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("v1/02_dash-template/layouts/layout-customer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gpumonster\core\resources\views/v1/02_dash-template/customer-pages/orders.blade.php ENDPATH**/ ?>