<?php $__env->startSection('page-title'); ?>ثبت نام کاربر جدید<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
<style>.rtl .auth-2 {float: right;} .jq-toast-single {font-family: var(--main-font-family)}</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-body'); ?>
    <p class="auth-msg">ثبت نام کاربر جدید</p>
    <form id="register-form" class="form-element" method="POST" action="<?php echo e(route('register.submit')); ?>">
        <?php echo csrf_field(); ?>
        <input id="type" type="hidden" name="type" value="otprequest">
        <div class="form-group has-feedback">
            <input type="text" class="form-control" name="firstname" value="<?php echo e(old('firstname')); ?>" placeholder="نام" required>
            <span class="ion ion-person form-control-feedback "></span>
        </div>
        <div class="form-group has-feedback">
            <input type="text" class="form-control" name="lastname" value="<?php echo e(old('lastname')); ?>" placeholder="نام خانوادگی" required>
            <span class="ion ion-person form-control-feedback "></span>
        </div>
        <div class="form-group has-feedback">
            <input type="text" class="form-control" name="idnum" value="<?php echo e(old('idnum')); ?>" placeholder="کد ملی" required>
            <span class="ion ion-person-add form-control-feedback "></span>
        </div>
        <div class="form-group has-feedback">
            <input type="text" class="form-control" name="mobile" value="<?php echo e(old('mobile')); ?>" placeholder="شماره موبایل" required>
            <span class="ion ion-android-phone-portrait form-control-feedback "></span>
        </div>
        <div class="form-group has-feedback">
            <input type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" placeholder="پست الکترونیک" required>
            <span class="ion ion-email form-control-feedback "></span>
        </div>
        <div class="form-group has-feedback">
            <input type="password" class="form-control" name="password" placeholder="رمز عبور" required>
            <span class="ion ion-locked form-control-feedback "></span>
        </div>
        <div class="form-group has-feedback">
            <input type="password" class="form-control" name="password_confirmation" placeholder="تکرار رمز عبور" required>
            <span class="ion ion-locked form-control-feedback "></span>
        </div>
        <div class="row">
            <div class="col-12 text-center">
                <a href="#" class="text-danger" target="_blank"><b>قوانین و مقررات</b></a> را مطالعه کرده و با آن موافقم
            </div>
            <div class="col-12 text-center">
                <div id="otp-field" class="form-group has-feedback d-none">
                    <input type="text" class="form-control" name="otpval" placeholder="کد اغتبار سنجی ۶ رقمی" required>
                    <span class="ion ion-log-in form-control-feedback "></span>
                </div>

            </div>
        </div>
        <button type="submit" id="submit-btn" class="btn btn-block mt-10 btn-primary">دریافت کد اعتبارسنجی</button>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
<script>
    $('#submit-btn').click(function() {
        // e.preventDefault();
        let reqType  = $('#type').val();
        console.log(reqType);
        let formData = new FormData(document.getElementById("register-form"));
        let base_url = '<?php echo e(route('register.submit')); ?>';
        if (reqType === 'otprequest') {
            $.ajaxSetup({
                headers: {
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            });
            $.ajax({
                type:'POST',
                url: base_url,
                data: formData,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $("#submit-btn").attr('disabled', true).html('در حال ارسال کد اعتبارسنجی...')
                },
                success: function (response) {
                    $("#type").val('register');
                    $("#otp-field").removeClass('d-none');
                    $("#submit-btn").attr('disabled', false).html('ثبت نام');
                    $.toast({
                        text: 'لطفا کد اعتبارسنجی دریافتی را وارد نمایید',
                        position: 'bottom-left',
                        loaderBg: '#49ff77',
                        icon: 'success',
                        textAlign: 'center',
                        hideAfter: 5000
                    });
                    alert(response['otp']);
                },
                error: function(response){
                    let obj = response.responseJSON.errors;
                    Object.keys(obj).forEach(key => {
                        $.toast({
                            text: obj[key],
                            position: 'bottom-left',
                            loaderBg: '#ff6849',
                            icon: 'error',
                            textAlign: 'center',
                            hideAfter: 10000
                        });
                    });
                    $("#submit-btn").attr('disabled', false).html('دریافت کد اعتبارسنجی');
                },
                complete: function () {
                    console.log('done');
                }
            });
        } else {
            $('#register-form').submit();
        }
    });
    // $('#register-form').submit(function(e) {
    //
    // });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('v1/01_public/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gpumonsters\core\resources\views/v1/01_public/register-user.blade.php ENDPATH**/ ?>