<?php $__env->startSection('page-body'); ?>
<!-- ======= Hero Section ======= -->
<section id="hero" class="hero d-flex align-items-center">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 d-flex flex-column justify-content-center">
                <h1 data-aos="fade-up"><?php echo $homeItem['jumbotron-title']; ?></h1>
                <h2 class="text-justify" data-aos="fade-up" data-aos-delay="400"><?php echo $homeItem['jumbotron-description']; ?></h2>
                <div data-aos="fade-up" data-aos-delay="600">
                    <div class="text-center text-lg-start">
                        <a href="<?php echo e($homeItem['jumbotron-btnlink']); ?>" class="btn-get-started scrollto d-inline-flex align-items-center justify-content-center align-self-center">
                            <span><?php echo $homeItem['jumbotron-btntitle']; ?></span>
                            <i class="bi bi-arrow-left"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 hero-img" data-aos="zoom-out" data-aos-delay="200">
                <img src="<?php echo e($homeItem['jumbotron-picture']); ?>" class="img-fluid" alt="">
            </div>
        </div>
    </div>
</section>
<!-- End Hero -->

<main id="main">
    <!-- ======= Services Section ======= -->
    <section id="services" class="services">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <h2>خدمات ما</h2>
                <p>خدمات قابل ارائه به مشتریان</p>
            </header>

            <div class="row gy-4">
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
                    <div class="service-box purple">
                        <i class="bi bi-cpu icon"></i>
                        <h3>CPU Rendering</h3>
                        <p>پردازش تصویر و تصویر سازی در هسته های پردازنده به صورت موازی. در نرم افزار هایی مانند کرونا</p>
                        <a href="#" class="read-more"><span>ادامه مطلب</span> <i class="bi bi-arrow-left"></i></a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
                    <div class="service-box purple">
                        <i class="bi bi-gpu-card icon"></i>
                        <h3>GPU Rendering</h3>
                        <p>عمل پردازش گرافیکی و تصویر سازی با استفاده از کارت گرافیک های قدرتمند. در نرم افزار هایی مانند لومیون</p>
                        <a href="#" class="read-more"><span>ادامه مطلب</span> <i class="bi bi-arrow-left"></i></a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="800">
                    <div class="service-box purple">
                        <i class="bi bi-hdd-rack icon"></i>
                        <h3>Remote Workstation</h3>
                        <p>محیط کار مجازی جهت طراحی و کار با نرم افزار هایی که نیاز به کارت گرافیک ندارند</p>
                        <a href="#" class="read-more"><span>ادامه مطلب</span> <i class="bi bi-arrow-left"></i></a>
                    </div>
                </div>

            </div>

        </div>

    </section>
    <!-- End Services Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <h2>سرویس ها</h2>
                <p>سرویس های زیر قابل ارائه هستند</p>
            </header>
            <?php if(count($homeItem['services']) > 0): ?>
            <?php $timer = 100 ?>
            <div class="row gy-4" data-aos="fade-left">
                <?php $__currentLoopData = $homeItem['services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-delay="<?php echo e($timer); ?>">
                    <div class="box">
                        <h3><?php echo e($service->s_title); ?></h3>
                        <div class="icon"><i class="<?php echo e($service->icon); ?>"></i></div>
                        <?php echo $service->excerpt; ?>

                        <a href="#" class="btn-buy">ثبت سفارش</a>
                    </div>
                </div>
                <?php $timer += 200; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endif; ?>
        </div>

    </section>
    <!-- End Pricing Section -->

    <!-- ======= About Section ======= -->
    <section id="about" class="about">

        <div class="container" data-aos="fade-up">
            <div class="row gx-0">

                <div class="col-lg-6 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
                    <div class="content">
                        <h3>درباره ما</h3>
                        <h2><?php echo $homeItem['aboutus-title']; ?></h2>
                        <p>
                            <?php echo $homeItem['aboutus-description']; ?>

                        </p>
                        <div class="text-center text-lg-start">
                            <a href="<?php echo e($homeItem['aboutus-btnlink']); ?>" class="btn-read-more d-inline-flex align-items-center justify-content-center align-self-center">
                                <span>ادامه مطلب</span>
                                <i class="bi bi-arrow-left"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 d-flex align-items-center" data-aos="zoom-out" data-aos-delay="200">
                    <img src="<?php echo e(asset('statics/img/'.$homeItem['aboutus-picture'])); ?>" class="img-fluid" alt="about us picture">
                </div>
            </div>
        </div>

    </section>
    <!-- End About Section -->

    <!-- ======= F.A.Q Section ======= -->
    <!--    <section id="faq" class="faq">-->

    <!--        <div class="container" data-aos="fade-up">-->

    <!--            <header class="section-header">-->
    <!--                <h2>F.A.Q</h2>-->
    <!--                <p>سوالات متداول</p>-->
    <!--            </header>-->

    <!--            <div class="row">-->
    <!--                <div class="col-lg-12">-->
    <!--                    &lt;!&ndash; F.A.Q List&ndash;&gt;-->
    <!--                    <div class="accordion accordion-flush" id="faqlist1">-->
    <!--                        <div class="accordion-item">-->
    <!--                            <h2 class="accordion-header">-->
    <!--                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-1">-->
    <!--                                    یک عدد سوال عمومی-->
    <!--                                </button>-->
    <!--                            </h2>-->
    <!--                            <div id="faq-content-1" class="accordion-collapse collapse" data-bs-parent="#faqlist1">-->
    <!--                                <div class="accordion-body">-->
    <!--                                    لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است-->
    <!--                                </div>-->
    <!--                            </div>-->
    <!--                        </div>-->

    <!--                        <div class="accordion-item">-->
    <!--                            <h2 class="accordion-header">-->
    <!--                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-2">-->
    <!--                                    یک عدد سوال عمومی-->
    <!--                                </button>-->
    <!--                            </h2>-->
    <!--                            <div id="faq-content-2" class="accordion-collapse collapse" data-bs-parent="#faqlist1">-->
    <!--                                <div class="accordion-body">-->
    <!--                                    لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است-->
    <!--                                </div>-->
    <!--                            </div>-->
    <!--                        </div>-->

    <!--                        <div class="accordion-item">-->
    <!--                            <h2 class="accordion-header">-->
    <!--                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-3">-->
    <!--                                    یک عدد سوال عمومی-->
    <!--                                </button>-->
    <!--                            </h2>-->
    <!--                            <div id="faq-content-3" class="accordion-collapse collapse" data-bs-parent="#faqlist1">-->
    <!--                                <div class="accordion-body">-->
    <!--                                    لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است-->
    <!--                                </div>-->
    <!--                            </div>-->
    <!--                        </div>-->

    <!--                    </div>-->
    <!--                </div>-->

    <!--            </div>-->

    <!--        </div>-->

    <!--    </section>-->
    <!-- End F.A.Q Section -->

    <!-- ======= Recent Blog Posts Section ======= -->
    <section id="recent-blog-posts" class="recent-blog-posts">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <h2>خواندنی ها</h2>
                <p>آخرین اخبار متشر شده توسط تیم ما</p>
            </header>

            <div class="row">
                <?php if(isset($homeItem['blog-posts'][0])): ?>
                    <?php $__currentLoopData = $homeItem['blog-posts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4">
                            <div class="post-box">
                                <div class="post-img"><img src="<?php echo e($post['_embedded']['wp:featuredmedia'][0]['source_url']); ?>" class="img-fluid" alt=""></div>
                                <span class="post-date"><?php echo e($post['modified']); ?></span>
                                <h3 class="post-title"><?php echo e($post['title']['rendered']); ?></h3>
                                <a href="<?php echo e($post['link']); ?>" class="readmore stretched-link mt-auto" target="_blank"><span>ادامه مطلب</span><i class="bi bi-arrow-left"></i></a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="col-lg-12">
                        <p class="text-center">پستی برای نمایش موجود نیست</p>
                    </div>
                <?php endif; ?>
            </div>

        </div>

    </section><!-- End Recent Blog Posts Section -->

    <!-- ======= Contact Section ======= -->
    <section id="contact" class="contact">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <h2>تماس با ما</h2>
                <p>راه های ارتباط با ما</p>
            </header>

            <div class="row gy-4 text-center">
                <div class="col-12 col-md-4">
                    <div class="info-box">
                        <i class="bi bi-geo-alt"></i>
                        <h3>آدرس</h3>
                        <?php echo $homeItem['address']; ?>

                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="info-box">
                        <i class="bi bi-telephone"></i>
                        <h3>تلفن ها</h3>
                        <?php echo $homeItem['phone']; ?>

                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="info-box">
                        <i class="bi bi-envelope"></i>
                        <h3>پست الکترونیک</h3>
                        <?php echo $homeItem['email']; ?>

                    </div>
                </div>
            </div>
        </div>
    </section><!-- End Contact Section -->
</main><!-- End #main -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('v1/03_main-template/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gpumonsters\core\resources\views/v1/03_main-template/home.blade.php ENDPATH**/ ?>