<?php $__env->startSection("page-title"); ?> تیکت ها <?php $__env->stopSection(); ?>

<?php $__env->startSection("page-body"); ?>
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">لیست تیکت ها</h3>
            <div class="pull-right">
                <button type="button" class="btn btn-sm btn-outline btn-secondary btn-rounded" data-toggle="modal" data-target="#ticket-form-modal">ایجاد تیکت جدید</button>
            </div>
        </div>
        <div class="box-body">
            <div class="mailbox-messages">
                <div class="table-responsive">
                    <table class="table text-center">
                        <thead>
                            <tr class="bg-pale-primary">
                                <th class="font-weight-bold col-1">شماره</th>
                                <th class="font-weight-bold col-2">موضوع</th>
                                <th class="font-weight-bold col-4">آخرین تغییرات</th>
                                <th class="font-weight-bold col-2">وضعیت تیکت</th>
                                <th class="font-weight-bold col-1">مشاهده</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if(count($tickets) > 0): ?>
                            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($ticket->status == 1): ?>
                                    <tr class="bg-pale-secondary">
                                <?php elseif($ticket->seen_by_user == 1): ?>
                                    <tr class="bg-pale-success">
                                <?php elseif($ticket->seen_by_operator == 1): ?>
                                    <tr class="bg-pale-warning">
                                        <?php endif; ?>
                                        <td class="w-80">gmt-<?php echo e($ticket->id); ?></td>
                                        <td class="mailbox-subject"><?php echo e($ticket->subject); ?></td>
                                        <td class="ltr"><?php echo e(gregorianToJalali($ticket->created_at)); ?></td>
                                        <td class="ltr"><?php echo e($ticket->status == 0 ? ($ticket->seen_by_user ? 'باز - در انتظار پاسخ اپراتور' : 'باز - در انتظار پاسخ شما') : 'بسته'); ?></td>
                                        <td class="">
                                            <a href="<?php echo e(route('ticket-single.view', $ticket->id)); ?>" class="btn btn-social-icon btn-circle btn-xs btn-light mr-2"><i class="mdi mdi-view-sequential"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr class="bg-pale-secondary">
                                    <td colspan="5">شما هیچ تیکتی در سیستم ثبت نکرده‌اید</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-starter'); ?>
    <form action="./tickets" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="action" value="create">
        <input type="hidden" name="siteuser" value="<?php echo e(auth()->user()->idnum); ?>">
        <div class="modal modal-left fade" id="ticket-form-modal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header justify-content-center">
                        <h4 class="modal-title font-weight-bold">ایجاد تیکت جدید</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> موضوع تیکت</h5>
                                    <div class="controls">
                                        <input name="subject" value="<?php echo e(old('subject')); ?>" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <h5><span class="text-danger">*</span> شرح تیکت</h5>
                                    <div class="controls">
                                        <textarea name="content" class="form-control" rows="8"><?php echo e(old('content')); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer modal-footer-uniform">
                        <div class="row justify-content-center mt-2">
                            <div class="col-6">
                                <button id="submit-ticket" type="submit" class="btn btn-block btn-success">ثبت تیکت</button>
                            </div>
                            <div class="col-6">
                                <button type="button" class="btn btn-block btn-danger" data-dismiss="modal">بستن</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("v1/02_dash-template/layouts/layout-customer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gpumonsters\core\resources\views/v1/02_dash-template/customer-pages/tickets.blade.php ENDPATH**/ ?>