<?php $__env->startSection('tab-title'); ?>| سفارشات <?php $__env->stopSection(); ?>

<?php $__env->startSection("page-title"); ?> سفارشات <?php $__env->stopSection(); ?>

<?php $__env->startSection('page-styles'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset("statics/dash-template/vendor_components/datatable/datatables.min.css")); ?>"/>
<style>
    table {
        cursor: default !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("page-body"); ?>
<div class="box">
    <div class="box-body">
        <div class="table-responsive">
            <table class="table table-sm table-bordered text-center">
                <thead>
                    <tr class="bg-pale-dark">
                        <th class="font-weight-bold">#</th>
                        <th class="font-weight-bold">کد ملی</th>
                        <th class="font-weight-bold">نام کامل</th>
                        <th class="font-weight-bold">سرویس</th>
                        <th class="font-weight-bold">نوع</th>
                        <th class="font-weight-bold">حجم</th>
                        <th class="font-weight-bold">تاریخ ثبت</th>
                        <th class="font-weight-bold">تاریخ پرداخت</th>
                        <th class="font-weight-bold">وضعیت</th>
                        <th class="font-weight-bold">تغییر وضعیت</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="<?php if($order->status == "reserved"): ?> bg-pale-warning <?php elseif($order->status == "done"): ?> bg-pale-success <?php else: ?> bg-pale-danger <?php endif; ?>">
                        <td><?php echo e($order->id); ?></td>
                        <td><?php echo e($order->idnum); ?></td>
                        <td><?php echo e($order->firstname.' '.$order->lastname); ?></td>
                        <td><?php echo e($order->title); ?></td>
                        <td><?php echo e(is_null($order->hours) ? "روزانه" : "ساعتی"); ?></td>
                        <td class="ltr"><?php echo e(is_null($order->hours) ? gregorianToJalali($order->from).' الی '.gregorianToJalali($order->until) : gregorianToJalali($order->date).' -> '.$order->hours); ?></td>
                        <td class="ltr"><?php echo e(gregorianToJalali($order->placement_datetime, "Y/m/d H:i")); ?></td>
                        <td class="ltr"><?php echo e(is_null($order->callback_datetime) ? "-" : gregorianToJalali($order->callback_datetime, "Y/m/d H:i")); ?></td>
                        <td class="ltr"><?php echo e($order->status); ?></td>
                        <form action="<?php echo e(route('change-order-status.submit')); ?>" method="post"><?php echo csrf_field(); ?> <input type="hidden" name="oid" value="<?php echo e($order->id); ?>">
                            <td>
                                <?php if($order->status == "reserved"): ?>
                                    <button class="btn btn-social-icon btn-circle btn-sm btn-success m-0" name="action" value="done" type="submit"><i class="mdi mdi-check-circle-outline"></i></button> <button class="btn btn-social-icon btn-circle btn-sm btn-danger m-0" name="action" value="cancelled" type="submit"><i class="mdi mdi-cancel"></i></button>
                                <?php elseif($order->status == "done"): ?>
                                    <button class="btn btn-social-icon btn-circle btn-sm btn-danger m-0" name="action" value="cancelled" type="submit"><i class="mdi mdi-cancel"></i></button>
                                <?php else: ?>
                                    <button class="btn btn-social-icon btn-circle btn-sm btn-success m-0" name="action" value="done" type="submit"><i class="mdi mdi-check-circle-outline"></i></button>
                                <?php endif; ?>
                            </td>
                        </form>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <script src="<?php echo e(asset("statics/dash-template/vendor_components/datatable/datatables.min.js")); ?>"></script>
    <script>
        var table = $('table').DataTable();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("v1/02_dash-template/layouts/layout-admin", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gpumonster\core\resources\views/v1/02_dash-template/admin-pages/orders.blade.php ENDPATH**/ ?>