# Contributing

Contributions are welcome and will be fully credited. They are accepted via Pull Requests on [Laravel Toman](https://github.com/evryn/laravel-toman) repository.

# Things you can do
If you want to contribute but do not know where to start, this list provides some starting points.
 * Add a new payment gateway, for example:
   * [Pay.ir](https://pay.ir/)  
   * [PayPing.ir](https://www.payping.ir/)  
 * Refactor if you think there are better approach to do things.
 * Improve documents and comments; Fix grammatical errors, typos, etc.

💡 You can also check the [Todo section](https://github.com/evryn/laravel-toman/projects/1#column-13805265) to find what you can work on or discuss [new features](https://github.com/evryn/laravel-toman/discussions/categories/ideas) that you may find useful to have.

## Pull Requests

- **Add tests** - We need to have tests for the features.

- **Document any change in behaviour** - Make sure documents in `docs/` directory are kept up-to-date.

- **Consider our release cycle** - We're following [SemVer v2.0.0](http://semver.org/).

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **Write meaningful messages** - Make sure each individual commit message in your pull request is meaningful.


**Happy coding**!
