# About Toman (تومَن)
Toman is a Laravel package that makes working with popular payment gateways much easier.

There are dozens of gateway handlers; Here is why you may choose Laravel Toman:

## Heavily Tested
<a target="_blank" href="https://github.com/evryn/laravel-toman/actions/workflows/tests.yml?query=branch:master">
    <img alt="Build Status" src="https://img.shields.io/github/actions/workflow/status/evryn/laravel-toman/tests.yml?branch=master&label=tests&style=flat-square">
</a>
<a target="_blank" href="https://codecov.io/gh/evryn/laravel-toman">
    <img alt="Code Coverage" src='https://img.shields.io/codecov/c/github/evryn/laravel-toman?label=coverage&style=flat-square'>
</a>

Payment is a critical topic, and its handlers must be tested from all aspects. Laravel Toman has an automated test suit with high coverage. On every released build, we're forced to pass all tests so you can add a payment to your code with confidence.

## Elegant API

APIs are pretty much easy to use! Requesting a new payment and verifying it will add ~10 lines to your codebase! 😎

## Supports Multiple Gateways

We are planning to add new gateway providers. They'll require minimum possible changes in your code.
Currently, following gateways are available to use:  
✅ [Zarinpal.com](https://zarinpal.com)  
✅ [IDPay.ir](https://idpay.ir)  
🔘 [YekPay.com](https://yekpay.com/)  
🔘 [Pay.ir](https://pay.ir/)  
🔘 [PayPing.ir](https://www.payping.ir/)  
🔘 ...

## Easy to Test

Writing a test for your application and want to see if you're using the package correctly? No problem at all!

See our testing instructions in your payment gateway section!

<br></br>
➡ Why don't you see yourself? [Quick Start](getting-started.md)

➡ Looking for old documents? <a href="v1/index.html">V1 Docs</a>
