# About Toman (تومَن)
Toman is a Laravel package which makes working with popular payment gateways much easier.

There are dozens of gateway handlers; Here is why you may choose Laravel Toman:

## Heavily Tested
<a target="_blank" href="https://github.com/evryn/laravel-toman/actions/workflows/tests.yml?query=branch:master">
    <img alt="Build Status" src="https://img.shields.io/github/workflow/status/evryn/laravel-toman/tests/master?label=tests&style=flat-square">
</a>
<a target="_blank" href="https://codecov.io/gh/evryn/laravel-toman">
    <img alt="Code Coverage" src='https://img.shields.io/codecov/c/github/evryn/laravel-toman?label=coverage&style=flat-square'>
</a>

Payment is critical topic and its handlers must be tested from all aspects. Laravel Toman has an automated test suit with 100% coverage. On every released build, we're enforced to pass all tests so you can add payment to your code with confidence.

## Elegant API

API and methods are pretty easy to use! Requesting a new payment and verifying it will add <170 characters to your code base! 😎

## Supports Multiple Gateways

Will support indeed. We'll stick to simple-to-use and completely-tested package so adding new gateways may take some times.

Currently following gateways are available to use:  
✅ [Zarinpal.com](https://zarinpal.com)  
🔘 [YekPay.com](https://yekpay.com/)  
🔘 [Pay.ir](https://pay.ir/)  
🔘 [PayPing.ir](https://www.payping.ir/)  
🔘 ...

## Easy to Test

Writing test for your own application and want to see if you're using the package correctly? No problem at all!

See our [Testing Guide](testing.md) to learn about how to mock gateways and assert things!

<br></br>
➡ Why don't you see yourself? [Quick Start](quickstart.md)
