<?php  get_header(); ?>
<main id="main">
	<!-- ======= Breadcrumbs ======= -->
	<section class="breadcrumbs">
		<div class="container">
			<ol>
                <li><a href="#">خانه</a></li>
                <li><a href="<?= get_site_url(); ?>">خواندنی ها</a></li>
			</ol>
			<h2>اخبار دنیای تکنولوژی</h2>
		</div>
	</section>
    <!-- End Breadcrumbs -->
	<!-- ======= Blog Section ======= -->
	<section id="blog" class="blog">
		<div class="container" data-aos="fade-up">
			<div class="row">
				<div class="col-lg-8 entries">
					<?php
					$args = array(
						'posts_per_page'   =>10,
						'offset'           => 0,
						'category'         => '',
						'category_name'    => '',
						'orderby'          => 'post_date',
						'order'            => 'DESC',
						'include'          => '',
						'exclude'          => '',
						'meta_key'         => '',
						'meta_value'       => '',
						'post_type'        => 'post',
						'post_mime_type'   => '',
						'post_parent'      => '',
						'post_status'      => 'publish',
						'suppress_filters' => true
                    );
					$posts = get_posts( $args );
                    foreach ( $posts as $post ) : setup_postdata( $post ); ?>
					<article class="entry">
						<div class="entry-img">
							<img src="<?php the_post_thumbnail_url(); ?>" alt="" class="img-fluid">
						</div>
						<h2 class="entry-title">
							<a href="<?= the_permalink(); ?>"><?php the_title() ?></a>
						</h2>
						<div class="entry-meta">
							<ul>
								<li class="d-flex align-items-center"><i class="bi bi-person"></i> <a href="#"><?= get_the_author() ?></a></li>
								<li class="d-flex align-items-center"><i class="bi bi-clock"></i> <a href="#"><time datetime="<?= get_the_date() ?>"><?= get_the_date() ?></time></a></li>
							</ul>
						</div>
						<div class="entry-content">
							<p><?php the_excerpt(); ?></p>
							<div class="read-more">
								<a href="<?= the_permalink(); ?>">ادامه مطلب</a>
							</div>
						</div>
					</article>
                    <?php endforeach; ?>
<!--					<div class="blog-pagination">-->
<!--						<ul class="justify-content-center">-->
<!--							<li><a href="#">1</a></li>-->
<!--							<li class="active"><a href="#">2</a></li>-->
<!--							<li><a href="#">3</a></li>-->
<!--						</ul>-->
<!--					</div>-->
				</div>
                <!-- End blog entries list -->
				<div class="col-lg-4">
					<div class="sidebar">
						<h3 class="sidebar-title">جستجو</h3>
						<div class="sidebar-item search-form">
							<form action="">
								<input type="text">
								<button type="submit"><i class="bi bi-search"></i></button>
							</form>
						</div>
                        <!-- End sidebar search form-->
						<h3 class="sidebar-title">دسته بندی ها</h3>
						<div class="sidebar-item categories">
							<ul>
                            <?php
                            $args = array(
                                'orderby' => 'slug',
                                'parent' => 0
                            );
                            $categories = get_categories( $args );
                            foreach( $categories as $category )
                                echo '<li><a href="'.get_site_url().'/category/'.$category->slug.'">'. $category->name .' <span>('. $category->category_count .')</span></a></li>';
                            ?>
							</ul>
						</div>
                        <!-- End sidebar categories-->
						<h3 class="sidebar-title">تگ ها</h3>
						<div class="sidebar-item tags">
                            <ul>
							<?php
							$tags = get_the_tags();
							foreach ($tags as $tag) :
								?>
                                <li><a href="<?= get_site_url(); ?>/tag/<?= $tag->slug ?>"><?= $tag->name ?></a></li>
							<?php endforeach; ?>
							</ul>
						</div>
                        <!-- End sidebar tags-->
					</div>
                    <!-- End sidebar -->
				</div>
                <!-- End blog sidebar -->
			</div>
		</div>
	</section>
    <!-- End Blog Section -->
</main>
<!-- End #main -->
<?php  get_footer(); ?>
</body>
</html>
